/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation15;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation15.Animation15_Blocks;
import me.davidml16.acubelets.animations.animation.animation15.Animation15_RotatingFlame;
import me.davidml16.acubelets.animations.animation.animation15.Animation15_Serpent;
import me.davidml16.acubelets.animations.animation.animation15.Animation15_Spiral;
import me.davidml16.acubelets.utils.LocationUtils;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.SkullCreator;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.XSeries.ParticleDisplay;
import me.davidml16.acubelets.utils.XSeries.XParticle;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class Animation15_Task
extends Animation {
    private ArmorStand armorStand;
    private Location armorStandLocation;
    private Set<Animation15_RotatingFlame> orbits = new HashSet<Animation15_RotatingFlame>();
    private BukkitTask blackHole;

    public Animation15_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n > 0 && n < 10) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.25, 0.0);
        } else if (n > 10 && n < 20) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.2, 0.0);
        } else if (n > 20 && n < 30) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.15, 0.0);
        } else if (n > 30 && n < 40) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.1, 0.0);
        } else if (n > 40 && n < 50) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.05, 0.0);
        }
        if (this.armorStand != null && n < 152) {
            this.armorStand.teleport(this.armorStandLocation);
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.26, 0.0));
        }
        if (n == 45) {
            Object object;
            this.addRunnable("serpent", new Animation15_Serpent(this.getCubeletBox().getLocation().clone().add(0.0, 1.0, 0.0).setDirection(new Vector(-1, 0, -1)), false));
            this.startRunnable("serpent", 0L, 1L);
            Location location = this.armorStand.getEyeLocation().add(0.0, 0.4, 0.0);
            for (Location object3 : LocationUtils.getCircle(this.armorStand.getLocation().clone().add(0.0, 0.75, 0.0), 0.25, 50)) {
                object = object3.toVector().subtract(this.armorStand.getLocation().clone().add(0.0, 0.75, 0.0).toVector()).normalize();
                UtilParticles.display(Particles.FLAME, object, location, 0.3f);
            }
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.FIREWORK_BLAST, 0.5f, 0.0f);
            try {
                this.blackHole = XParticle.blackhole(this.getMain(), 8, 4.0, 200.0, 2, 999999, ParticleDisplay.display(this.getCubeletBox().getLocation().clone().add(0.5, 7.0, 0.5), Particle.SMOKE_LARGE).withCount(1));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            Object object4 = new Animation15_RotatingFlame(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, 6.0, 0.5), 5.0f, 120, true, 0);
            object4.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.orbits.add((Animation15_RotatingFlame)((Object)object4));
            Animation15_RotatingFlame animation15_RotatingFlame = new Animation15_RotatingFlame(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, 6.0, 0.5), 5.0f, 120, true, 40);
            animation15_RotatingFlame.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.orbits.add(animation15_RotatingFlame);
            object = new Animation15_RotatingFlame(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, 6.0, 0.5), 5.0f, 120, true, 80);
            object.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.orbits.add((Animation15_RotatingFlame)((Object)object));
            this.cancelRunnable("spiral");
        }
        if (n == 150) {
            if (this.blackHole != null) {
                this.blackHole.cancel();
            }
            try {
                for (Object object4 : this.orbits) {
                    object4.cancel();
                    if (!this.getMain().getAnimationHandler().getEntities().contains(object4.getArmorStand())) continue;
                    ArmorStand armorStand = object4.getArmorStand();
                    if (armorStand != null) {
                        armorStand.remove();
                    }
                    this.getMain().getAnimationHandler().getEntities().remove(armorStand);
                }
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                // empty catch block
            }
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.IRONGOLEM_DEATH, 0.5f, 0.0f);
            UtilParticles.display(Particles.EXPLOSION_LARGE, this.armorStand.getLocation().clone().add(0.0, 1.25, 0.0), 2);
            this.armorStand.setGravity(true);
            ASSpawner.setEntityNoclip((Entity)this.armorStand);
        } else if (n > 150 && n < 165) {
            UtilParticles.display(Particles.FLAME, 0.1f, 0.25, 0.15f, this.armorStand.getLocation().clone().add(0.0, 1.5, 0.0), 5);
        }
        if (n == 163) {
            this.doPreRewardReveal();
        }
        if (n == 185) {
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.LEVEL_UP, 0.5f, 1.0f);
        }
    }

    @Override
    public void onStart() {
        this.setAnimationBlocks(new Animation15_Blocks(this.getCubeletBox().getLocation()));
        this.startAnimationBlocks(0L);
        this.setColors(Arrays.asList(Color.BLACK, Color.ORANGE));
        this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, -0.3, 0.5), SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTlhNWExZTY5YjRmODEwNTYyNTc1MmJjZWUyNTM0MDY2NGIwODlmYTFiMmY1MjdmYTkxNDNkOTA2NmE3YWFkMiJ9fX0="), false, false, true);
        this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        this.armorStandLocation = this.armorStand.getLocation();
        Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.FIREWORK_LAUNCH, 0.5f, 0.0f);
        this.addRunnable("spiral", new Animation15_Spiral(this.armorStand));
        this.startRunnable("spiral", 0L, 1L);
    }

    @Override
    public void onStop() {
        this.cancelRunnables();
        if (this.blackHole != null) {
            this.blackHole.cancel();
        }
        try {
            for (Animation15_RotatingFlame animation15_RotatingFlame : this.orbits) {
                animation15_RotatingFlame.cancel();
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation15_RotatingFlame.getArmorStand())) continue;
                ArmorStand armorStand = animation15_RotatingFlame.getArmorStand();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        this.stopAnimationBlocks();
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
        Sounds.playSound(this.armorStand.getLocation(), Sounds.MySound.EXPLODE, 0.5f, 1.0f);
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 1.5, 0.5), FireworkEffect.Type.BURST, this.getColors().get(0), this.getColors().get(1));
    }

    @Override
    public void onRewardReveal() {
        this.armorStand.remove();
        this.armorStand = null;
    }
}

