/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation8;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation8.Animation8_Bell;
import me.davidml16.acubelets.animations.animation.animation8.Animation8_Blocks;
import me.davidml16.acubelets.animations.animation.animation8.Animation8_PlaceSound;
import me.davidml16.acubelets.animations.animation.animation8.Animation8_Tree;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitRunnable;

public class Animation8_Task
extends Animation {
    private ArmorStand present;
    private Location pc1;
    private Location pc2;

    public Animation8_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n >= 65 && n < 120 && n % 2 == 0) {
            UtilParticles.display(Particles.NOTE, this.getRandomLocation(this.getCubeletBox().getLocation().clone().add(1.0, 0.0, 1.0), this.getCubeletBox().getLocation().clone().add(-1.0, 3.0, -1.0)));
        }
        if (n == 120) {
            BukkitRunnable bukkitRunnable = this.getRunnable("tree");
            if (bukkitRunnable != null) {
                ((Animation8_Tree)bukkitRunnable).restore();
            }
            this.cancelRunnable("bell");
            this.present = ASSpawner.spawn(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, 3.0, 0.5), this.getCubeletType().getIcon(), false, true);
            this.getMain().getAnimationHandler().getEntities().add((Entity)this.present);
            this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 4.25, 0.5), FireworkEffect.Type.BURST, Color.YELLOW, Color.YELLOW);
        }
        if (n == 130) {
            this.present.setGravity(false);
            this.present.teleport(this.getCubeletBox().getLocation().clone().add(0.5, -0.625, 0.5));
        }
        if (n == 153) {
            this.doPreRewardReveal();
        }
        if (n % 2 == 0) {
            UtilParticles.display(Particles.FIREWORKS_SPARK, this.getRandomLocation(this.pc1, this.pc2));
        }
    }

    @Override
    public void onStart() {
        this.setAnimationBlocks(new Animation8_Blocks(this.getCubeletBox().getLocation()));
        this.startAnimationBlocks(0L);
        this.addRunnable("placeSound", new Animation8_PlaceSound(this.getCubeletBox().getLocation().clone().add(0.5, 0.0, 0.5)));
        this.startRunnable("placeSound", 0L, 5L);
        this.addRunnable("bell", new Animation8_Bell(this.getCubeletBox().getLocation().clone().add(0.5, 0.0, 0.5)));
        this.startRunnable("bell", 65L, 3L);
        this.addRunnable("tree", new Animation8_Tree(this.getMain(), (Animation8_PlaceSound)this.getRunnable("placeSound"), this.getCubeletBox().getLocation().clone().add(0.5, 0.0, 0.5)));
        this.startRunnable("tree", 18L, 5L);
        this.setColors(Arrays.asList(Color.RED, Color.WHITE));
        this.pc1 = this.getCubeletBox().getLocation().clone().add(-3.0, -1.0, -3.0);
        this.pc2 = this.getCubeletBox().getLocation().clone().add(3.0, 4.0, 3.0);
    }

    @Override
    public void onStop() {
        this.cancelRunnables();
        this.stopAnimationBlocks();
        BukkitRunnable bukkitRunnable = this.getRunnable("tree");
        if (bukkitRunnable != null) {
            ((Animation8_Tree)bukkitRunnable).restore();
        }
        if (this.getMain().getAnimationHandler().getEntities().contains(this.present)) {
            if (this.present != null) {
                this.present.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.present);
        }
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 1.5, 0.5), FireworkEffect.Type.STAR, this.getColors().get(0), this.getColors().get(1));
    }

    @Override
    public void onRewardReveal() {
        this.present.remove();
        this.present = null;
    }

    public Location getRandomLocation(Location location, Location location2) {
        double d = Math.min(location.getX(), location2.getX());
        double d2 = Math.min(location.getY(), location2.getY());
        double d3 = Math.min(location.getZ(), location2.getZ());
        double d4 = Math.max(location.getX(), location2.getX());
        double d5 = Math.max(location.getY(), location2.getY());
        double d6 = Math.max(location.getZ(), location2.getZ());
        return new Location(location.getWorld(), this.randomDouble(d, d4), this.randomDouble(d2, d5), this.randomDouble(d3, d6));
    }

    public double randomDouble(double d, double d2) {
        return d + ThreadLocalRandom.current().nextDouble(Math.abs(d2 - d + 1.0));
    }
}

