/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.type.TypeSettingsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XItemStack;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TypeKeyConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public TypeKeyConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CubeletType cubeletType) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RenameMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"type", (Object)cubeletType);
        conversation.getContext().setSessionData((Object)"typeKey", (Object)cubeletType.getKey());
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    public class RenameMenuOptions
    extends FixedSetPrompt {
        RenameMenuOptions() {
            super(new String[]{"1", "2"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            CubeletType cubeletType = (CubeletType)conversationContext.getSessionData((Object)"type");
            Player player = (Player)conversationContext.getSessionData((Object)"player");
            switch (string) {
                case "1": {
                    Player player2 = (Player)conversationContext.getSessionData((Object)"player");
                    ItemStack itemStack = player2.getInventory().getItemInHand();
                    if (itemStack == null || itemStack.getType() == Material.AIR) {
                        conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  AIR icon not allowed!\n ");
                        Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                        return this;
                    }
                    conversationContext.setSessionData((Object)"typeKey", (Object)itemStack);
                    conversationContext.getForWhom().sendRawMessage(ChatColor.GREEN + "  Succesfully setup type key.");
                    Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
                    return this;
                }
                case "2": {
                    ItemStack itemStack = (ItemStack)conversationContext.getSessionData((Object)"typeKey");
                    cubeletType.setKey(itemStack);
                    FileConfiguration fileConfiguration = TypeKeyConversation.this.main.getCubeletTypesHandler().getConfig(cubeletType.getId());
                    fileConfiguration.set("type.key", null);
                    if (!TypeKeyConversation.this.main.isSerializeBase64()) {
                        XItemStack.serializeItem(itemStack, fileConfiguration, "type.key");
                    } else {
                        fileConfiguration.set("type.key", (Object)XItemStack.itemStackToBase64(itemStack));
                    }
                    TypeKeyConversation.this.main.getCubeletTypesHandler().saveConfig(cubeletType.getId());
                    conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(TypeKeyConversation.this.main.getLanguageHandler().getPrefix() + " &aSaved key of cubelet type &e" + cubeletType.getId() + " &awithout errors!"));
                    Sounds.playSound(player, player.getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                    TypeKeyConversation.this.main.getMenuHandler().reloadAllMenus(TypeSettingsMenu.class);
                    TypeSettingsMenu typeSettingsMenu = new TypeSettingsMenu(TypeKeyConversation.this.main, player);
                    typeSettingsMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                    typeSettingsMenu.open();
                    TypeKeyConversation.this.main.getConversationHandler().removeConversation(player);
                    return Prompt.END_OF_CONVERSATION;
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET TYPE KEY MENU\n";
            string = string + ChatColor.GREEN + " \n";
            if (conversationContext.getSessionData((Object)"typeKey") == null) {
                string = string + ChatColor.RED + "    1 " + ChatColor.GRAY + "- Edit reward icon 'Item in Hand' (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n";
            } else {
                ItemStack itemStack = (ItemStack)conversationContext.getSessionData((Object)"typeKey");
                string = string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Edit type key 'Item in Hand' (" + ChatColor.YELLOW + itemStack.getType().name() + ChatColor.GRAY + ")\n";
            }
            string = string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Save and exit\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

