/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.database.types;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import java.sql.Connection;
import java.sql.SQLException;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.database.types.DatabaseConnection;
import me.davidml16.acubelets.utils.Utils;

public class MySqlConnection
implements DatabaseConnection {
    private Main main;
    private HikariDataSource hikari;
    private final String host;
    private final String user;
    private final String password;
    private final String database;
    private final int port;

    public MySqlConnection(Main main) {
        this.main = main;
        this.host = main.getConfig().getString("MySQL.Host");
        this.user = main.getConfig().getString("MySQL.User");
        this.password = main.getConfig().getString("MySQL.Password");
        this.database = main.getConfig().getString("MySQL.Database");
        this.port = main.getConfig().getInt("MySQL.Port");
    }

    @Override
    public void open() {
        if (this.hikari != null) {
            return;
        }
        try {
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setPoolName("    ACubelets Pool");
            hikariConfig.setJdbcUrl("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database);
            hikariConfig.setUsername(this.user);
            hikariConfig.setPassword(this.password);
            hikariConfig.setMaximumPoolSize(75);
            hikariConfig.setMinimumIdle(4);
            hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
            hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
            hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            this.hikari = new HikariDataSource(hikariConfig);
            this.hikari.getConnection();
            Main.log.sendMessage(Utils.translate("    &aMySQL has been enabled!"));
        }
        catch (HikariPool.PoolInitializationException | SQLException exception) {
            Main.log.sendMessage(Utils.translate("    &cMySQL has an error on the conection! Now trying with SQLite..."));
            this.main.getDatabase().changeToSQLite();
        }
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.hikari != null) {
                return this.hikari.getConnection();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    @Override
    public void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (this.hikari == null) {
            return;
        }
        this.hikari.close();
    }
}

