/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.enums.CraftType;
import me.davidml16.acubelets.objects.CraftIngredient;
import me.davidml16.acubelets.objects.CraftParent;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class CubeletCraftingHandler {
    private File file;
    private YamlConfiguration config;
    private List<CraftParent> crafts;
    private int inventorySize;
    private Main main;

    public CubeletCraftingHandler(Main main) {
        this.main = main;
        this.crafts = new ArrayList<CraftParent>();
    }

    public File getFile() {
        return this.file;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public List<CraftParent> getCrafts() {
        return this.crafts;
    }

    public CraftParent getCraftById(String string) {
        for (CraftParent craftParent : this.crafts) {
            if (!craftParent.getCubeletType().equalsIgnoreCase(string)) continue;
            return craftParent;
        }
        return null;
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void loadCrafting() {
        this.crafts.clear();
        this.file = new File(this.main.getDataFolder(), "cubelet-crafting.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                this.config.set("cubelet-crafting.settings.rows", (Object)4);
                this.config.set("cubelet-crafting.crafts", new ArrayList());
                this.saveConfig();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!this.config.contains("cubelet-crafting.settings.rows")) {
            this.config.set("cubelet-crafting.settings.rows", (Object)4);
        }
        if (!this.config.contains("cubelet-crafting.crafts")) {
            this.config.set("cubelet-crafting.crafts", new ArrayList());
        }
        this.saveConfig();
        this.inventorySize = this.config.getInt("cubelet-crafting.settings.rows");
        Main.log.sendMessage(Utils.translate("  &eLoading crafts:"));
        if (this.config.contains("cubelet-crafting.crafts") && this.config.getConfigurationSection("cubelet-crafting.crafts") != null) {
            for (String string : this.config.getConfigurationSection("cubelet-crafting.crafts").getKeys(false)) {
                int n;
                if (!this.main.getCubeletTypesHandler().getTypes().containsKey(string) || (n = this.config.getInt("cubelet-crafting.crafts." + string + ".slot")) > this.getInventorySize() - 10 || n < 0) continue;
                ArrayList<CraftIngredient> arrayList = new ArrayList<CraftIngredient>();
                if (this.config.contains("cubelet-crafting.crafts." + string + ".ingredients") && this.config.getConfigurationSection("cubelet-crafting.crafts." + string + ".ingredients") != null) {
                    for (int i = 1; i <= this.config.getConfigurationSection("cubelet-crafting.crafts." + string + ".ingredients").getKeys(false).size(); ++i) {
                        String string2 = this.config.getString("cubelet-crafting.crafts." + string + ".ingredients." + i + ".type");
                        if (!string2.equalsIgnoreCase("money") && !string2.equalsIgnoreCase("cubelet") && !string2.equalsIgnoreCase("points")) continue;
                        int n2 = this.config.getInt("cubelet-crafting.crafts." + string + ".ingredients." + i + ".amount");
                        if (string2.equalsIgnoreCase("money")) {
                            if (!this.main.getEconomyHandler().isLoaded()) continue;
                            arrayList.add(new CraftIngredient(string, CraftType.MONEY, n2));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("cubelet")) {
                            String string3 = this.config.getString("cubelet-crafting.crafts." + string + ".ingredients." + i + ".name");
                            if (string3 == null || !this.main.getCubeletTypesHandler().getTypes().containsKey(string3)) continue;
                            arrayList.add(new CraftIngredient(string, CraftType.CUBELET, string3, n2));
                            continue;
                        }
                        if (!string2.equalsIgnoreCase("points")) continue;
                        arrayList.add(new CraftIngredient(string, CraftType.POINTS, n2));
                    }
                }
                this.crafts.add(new CraftParent(string, n, arrayList));
            }
        }
        if (this.crafts.size() == 0) {
            Main.log.sendMessage(Utils.translate("    &cNo Cubelet crafts has been loaded!"));
        } else {
            Main.log.sendMessage(Utils.translate("    &b" + this.crafts.size() + " &aCubelet crafts loaded!"));
        }
        Main.log.sendMessage(Utils.translate(""));
    }

    public void saveCrafting() {
        this.config.set("cubelet-crafting.settings.rows", (Object)this.inventorySize);
        this.config.set("cubelet-crafting.crafts", new ArrayList());
        for (CraftParent craftParent : this.crafts) {
            this.config.set("cubelet-crafting.crafts." + craftParent.getCubeletType() + ".slot", (Object)craftParent.getSlot());
            this.config.set("cubelet-crafting.crafts." + craftParent.getCubeletType() + ".ingredients", new ArrayList());
            int n = 1;
            for (CraftIngredient craftIngredient : craftParent.getIngrediens()) {
                this.config.set("cubelet-crafting.crafts." + craftParent.getCubeletType() + ".ingredients." + n + ".type", (Object)craftIngredient.getCraftType().toString().toLowerCase());
                if (craftIngredient.getCraftType() == CraftType.CUBELET) {
                    this.config.set("cubelet-crafting.crafts." + craftParent.getCubeletType() + ".ingredients." + n + ".name", (Object)craftIngredient.getName());
                }
                this.config.set("cubelet-crafting.crafts." + craftParent.getCubeletType() + ".ingredients." + n + ".amount", (Object)craftIngredient.getAmount());
                ++n;
            }
        }
        this.saveConfig();
    }

    public int getInventorySize() {
        int n = this.inventorySize;
        if (n >= 2 && n <= 6) {
            return n * 9;
        }
        return 36;
    }

    public int getInventoryRows() {
        return this.inventorySize;
    }

    public void setInventorySize(int n) {
        this.inventorySize = n;
    }

    public boolean haveIngredient(Player player, CraftIngredient craftIngredient) {
        if (craftIngredient.getCraftType() == CraftType.CUBELET) {
            long l = this.main.getPlayerDataHandler().getData(Objects.requireNonNull(player.getPlayer())).getCubelets().stream().filter(cubelet -> cubelet.getType().equalsIgnoreCase(craftIngredient.getName())).count();
            return l >= (long)craftIngredient.getAmount();
        }
        if (craftIngredient.getCraftType() == CraftType.MONEY) {
            return this.main.getEconomyHandler().getBalance(player) >= (double)craftIngredient.getAmount();
        }
        if (craftIngredient.getCraftType() == CraftType.POINTS) {
            return this.main.getPlayerDataHandler().getData(player).getLootPoints() >= (long)craftIngredient.getAmount();
        }
        return false;
    }

    public boolean haveIngredients(Player player, CraftParent craftParent) {
        for (CraftIngredient craftIngredient : craftParent.getIngrediens()) {
            if (this.haveIngredient(player, craftIngredient)) continue;
            return false;
        }
        return true;
    }

    public void removeIngredients(Player player, CraftParent craftParent) {
        for (CraftIngredient craftIngredient : craftParent.getIngrediens()) {
            if (craftIngredient.getCraftType() == CraftType.CUBELET) {
                try {
                    this.main.getTransactionHandler().removeCubelet(player.getUniqueId(), craftIngredient.getName(), craftIngredient.getAmount());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                continue;
            }
            if (craftIngredient.getCraftType() == CraftType.MONEY) {
                this.main.getEconomyHandler().removeBalance(player, craftIngredient.getAmount());
                continue;
            }
            if (craftIngredient.getCraftType() != CraftType.POINTS) continue;
            Profile profile = this.main.getPlayerDataHandler().getData(player);
            profile.setLootPoints(profile.getLootPoints() - (long)craftIngredient.getAmount());
        }
    }
}

