/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.util.ArrayList;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Rarity;
import org.bukkit.configuration.file.FileConfiguration;

public class CubeletRarityHandler {
    private Main main;

    public CubeletRarityHandler(Main main) {
        this.main = main;
    }

    public Rarity getRarityById(String string, String string2) {
        return this.main.getCubeletTypesHandler().getTypeBydId(string).getRarities().get(string2);
    }

    public boolean createRarity(String string, String string2, String string3, int n, String string4) {
        CubeletType cubeletType = this.main.getCubeletTypesHandler().getTypeBydId(string);
        cubeletType.getRarities().put(string2, new Rarity(string2, string3, n, string4));
        FileConfiguration fileConfiguration = this.main.getCubeletTypesHandler().getConfig(string);
        fileConfiguration.set("type.rarities", new ArrayList());
        for (Rarity rarity : cubeletType.getRarities().values()) {
            fileConfiguration.set("type.rarities." + rarity.getId() + ".name", (Object)rarity.getName());
            fileConfiguration.set("type.rarities." + rarity.getId() + ".chance", (Object)rarity.getChance());
            fileConfiguration.set("type.rarities." + rarity.getId() + ".duplicatePointsRange", (Object)rarity.getDuplicatePointsRange());
        }
        this.main.getCubeletTypesHandler().saveConfig(string);
        return true;
    }

    public boolean removeRarity(String string, String string2) {
        CubeletType cubeletType = this.main.getCubeletTypesHandler().getTypeBydId(string);
        if (cubeletType.getRarities().containsKey(string2)) {
            FileConfiguration fileConfiguration = this.main.getCubeletTypesHandler().getConfig(string);
            cubeletType.getRarities().remove(string2);
            fileConfiguration.set("type.rarities", new ArrayList());
            for (Rarity rarity : cubeletType.getRarities().values()) {
                fileConfiguration.set("type.rarities." + rarity.getId() + ".name", (Object)rarity.getName());
                fileConfiguration.set("type.rarities." + rarity.getId() + ".chance", (Object)rarity.getChance());
                fileConfiguration.set("type.rarities." + rarity.getId() + ".duplicatePointsRange", (Object)rarity.getDuplicatePointsRange());
            }
            this.main.getCubeletTypesHandler().saveConfig(string);
            return true;
        }
        return false;
    }

    public void loadRarities() {
        for (CubeletType cubeletType : this.main.getCubeletTypesHandler().getTypes().values()) {
            FileConfiguration fileConfiguration = this.main.getCubeletTypesHandler().getConfig(cubeletType.getId());
            cubeletType.getRarities().clear();
            if (!fileConfiguration.contains("type.rarities")) {
                fileConfiguration.set("type.rarities", new ArrayList());
            }
            this.main.getCubeletTypesHandler().saveConfig(cubeletType.getId());
            if (!fileConfiguration.contains("type.rarities") || fileConfiguration.getConfigurationSection("type.rarities") == null) continue;
            for (String string : fileConfiguration.getConfigurationSection("type.rarities").getKeys(false)) {
                String string2 = fileConfiguration.getString("type.rarities." + string + ".name");
                double d = fileConfiguration.getDouble("type.rarities." + string + ".chance");
                String string3 = fileConfiguration.contains("type.rarities." + string + ".duplicatePointsRange") ? fileConfiguration.getString("type.rarities." + string + ".duplicatePointsRange") : "50-450";
                cubeletType.getRarities().put(string, new Rarity(string, string2, d, string3));
            }
        }
    }

    public boolean rarityExist(String string, String string2) {
        CubeletType cubeletType = this.main.getCubeletTypesHandler().getTypeBydId(string);
        return cubeletType.getRarities().containsKey(string2);
    }
}

