/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.holograms.implementations;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.VisibilityManager;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.enums.CubeletBoxState;
import me.davidml16.acubelets.holograms.HologramHandler;
import me.davidml16.acubelets.holograms.HologramImplementation;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.RepeatingTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HolographicDisplaysImpl
implements HologramImplementation,
Listener {
    private Main main;
    private HologramHandler hologramHandler;
    private static final double LINE_HEIGHT = 0.36;
    private static final double LINE_HEIGHT_REWARD = 0.32;
    private HashMap<CubeletMachine, HashMap<UUID, Hologram>> holograms;

    public HolographicDisplaysImpl(Main main, HologramHandler hologramHandler) {
        this.main = main;
        this.hologramHandler = hologramHandler;
        this.holograms = new HashMap();
    }

    @Override
    public void loadHolograms() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.loadHolograms(player);
        }
    }

    @Override
    public void loadHolograms(Player player) {
        for (CubeletMachine cubeletMachine : this.main.getCubeletBoxHandler().getBoxes().values()) {
            this.loadHolograms(player, cubeletMachine);
        }
    }

    @Override
    public void loadHolograms(CubeletMachine cubeletMachine) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.loadHolograms(player, cubeletMachine);
        }
    }

    @Override
    public void removeHolograms() {
        for (Hologram hologram : HologramsAPI.getHolograms((Plugin)this.main)) {
            hologram.delete();
        }
    }

    @Override
    public void reloadHolograms() {
        this.hologramHandler.setActualColor(this.hologramHandler.getColorAnimation().nextColor());
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.reloadHolograms(player);
        }
    }

    @Override
    public void loadHolograms(Player player, CubeletMachine cubeletMachine) {
        Hologram hologram = HologramsAPI.createHologram((Plugin)this.main, (Location)cubeletMachine.getLocation().clone().add(0.5, 1.025 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        VisibilityManager visibilityManager = hologram.getVisibilityManager();
        visibilityManager.showTo(player);
        visibilityManager.setVisibleByDefault(false);
        if (cubeletMachine.getState() == CubeletBoxState.EMPTY) {
            List<String> list = this.hologramHandler.getLines(player);
            int n = Math.max(this.main.getLanguageHandler().getMessageList("Holograms.CubeletAvailable").size(), this.main.getLanguageHandler().getMessageList("Holograms.NoCubeletAvailable").size());
            for (String string : list) {
                hologram.appendTextLine(string);
            }
            hologram.teleport(cubeletMachine.getLocation().clone().add(0.5, (double)n * 0.36 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        } else if (cubeletMachine.getState() == CubeletBoxState.REWARD) {
            List<String> list = this.hologramHandler.getLinesReward(player, cubeletMachine.getPlayerOpening(), cubeletMachine.getLastReward());
            hologram.teleport(cubeletMachine.getLocation().clone().add(0.5, (double)list.size() * 0.32 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
            for (String string : list) {
                if (!string.contains("%reward_icon%")) {
                    hologram.appendTextLine(string);
                    continue;
                }
                hologram.appendItemLine(cubeletMachine.getLastReward().getIcon());
            }
        }
        if (this.holograms.get(cubeletMachine) == null) {
            this.holograms.put(cubeletMachine, new HashMap());
        }
        this.holograms.get(cubeletMachine).put(player.getUniqueId(), hologram);
    }

    @Override
    public void reloadHolograms(Player player) {
        for (CubeletMachine cubeletMachine : this.main.getCubeletBoxHandler().getBoxes().values()) {
            this.reloadHologram(player, cubeletMachine);
        }
    }

    @Override
    public void reloadHologram(CubeletMachine cubeletMachine) {
        for (Hologram hologram : this.holograms.get(cubeletMachine).values()) {
            hologram.clearLines();
        }
        for (Hologram hologram : Bukkit.getOnlinePlayers()) {
            this.reloadHologram((Player)hologram, cubeletMachine);
        }
    }

    @Override
    public void reloadHologram(Player player, CubeletMachine cubeletMachine) {
        if (this.holograms.get(cubeletMachine) == null || !this.holograms.get(cubeletMachine).containsKey(player.getUniqueId())) {
            return;
        }
        Hologram hologram = this.holograms.get(cubeletMachine).get(player.getUniqueId());
        if (!Objects.equals(cubeletMachine.getLocation().getWorld(), player.getLocation().getWorld()) || cubeletMachine.getLocation().distanceSquared(player.getLocation()) > (double)this.hologramHandler.getVisibilityDistance()) {
            if (hologram.getVisibilityManager().isVisibleTo(player)) {
                hologram.getVisibilityManager().hideTo(player);
            }
            return;
        }
        if (cubeletMachine.getState() == CubeletBoxState.EMPTY) {
            int n;
            List<String> list = this.hologramHandler.getLines(player);
            if (!hologram.getVisibilityManager().isVisibleTo(player)) {
                hologram.getVisibilityManager().showTo(player);
            }
            int n2 = Math.max(this.main.getLanguageHandler().getMessageList("Holograms.CubeletAvailable").size(), this.main.getLanguageHandler().getMessageList("Holograms.NoCubeletAvailable").size());
            if (hologram.size() != list.size()) {
                hologram.teleport(cubeletMachine.getLocation().clone().add(0.5, (double)n2 * 0.36 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
            }
            if (hologram.size() > list.size()) {
                for (n = list.size(); n < hologram.size(); ++n) {
                    hologram.getLine(n).removeLine();
                }
            } else if (hologram.size() < list.size()) {
                for (n = hologram.size(); n < list.size(); ++n) {
                    hologram.appendTextLine(list.get(n));
                }
            }
            for (n = 0; n < list.size(); ++n) {
                if (((TextLine)hologram.getLine(n)).getText().equalsIgnoreCase(list.get(n))) continue;
                ((TextLine)hologram.getLine(n)).setText(list.get(n));
            }
        }
    }

    @Override
    public void clearLines(CubeletMachine cubeletMachine) {
        for (Hologram hologram : this.holograms.get(cubeletMachine).values()) {
            hologram.clearLines();
        }
    }

    @Override
    public void clearHolograms(CubeletMachine cubeletMachine) {
        this.holograms.get(cubeletMachine).clear();
    }

    @Override
    public void moveHologram(CubeletMachine cubeletMachine) {
        int n = Math.max(this.main.getLanguageHandler().getMessageList("Holograms.CubeletAvailable").size(), this.main.getLanguageHandler().getMessageList("Holograms.NoCubeletAvailable").size());
        if (this.holograms.get(cubeletMachine) == null) {
            return;
        }
        for (Hologram hologram : this.holograms.get(cubeletMachine).values()) {
            hologram.teleport(cubeletMachine.getLocation().clone().add(0.5, (double)n * 0.36 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        }
    }

    @Override
    public void rewardHologram(CubeletMachine cubeletMachine, Reward reward) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.holograms.get(cubeletMachine) == null || !this.holograms.get(cubeletMachine).containsKey(player.getUniqueId())) continue;
            Hologram hologram = this.holograms.get(cubeletMachine).get(player.getUniqueId());
            hologram.clearLines();
            List<String> list = this.hologramHandler.getLinesReward(player, cubeletMachine.getPlayerOpening(), reward);
            hologram.teleport(cubeletMachine.getLocation().clone().add(0.5, (double)list.size() * 0.32 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
            for (String string : list) {
                if (!string.contains("%reward_icon%")) {
                    hologram.appendTextLine(string);
                    continue;
                }
                hologram.appendItemLine(reward.getIcon());
            }
        }
    }

    @Override
    public RepeatingTask duplicationRewardHologram(final CubeletMachine cubeletMachine, final Reward reward) {
        final int n = cubeletMachine.getLastDuplicationPoints();
        return new RepeatingTask(this.main, 0, 1){
            int pointsPerTick;
            int pointsToShow;
            {
                super(javaPlugin, n4, n2);
                this.pointsPerTick = n > 40 ? n / 40 : (n > 20 ? n / 20 : n / n);
                this.pointsToShow = 0;
            }

            @Override
            public void run() {
                if (this.pointsPerTick == 0) {
                    this.pointsPerTick = cubeletMachine.getLastDuplicationPoints() / 40;
                }
                List<String> list = HolographicDisplaysImpl.this.hologramHandler.getLinesRewardDuplicated(reward, this.pointsToShow);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!HolographicDisplaysImpl.this.main.isDuplicationVisibleAllPlayers() && !cubeletMachine.getPlayerOpening().getUuid().equals(player.getUniqueId()) || HolographicDisplaysImpl.this.holograms.get(cubeletMachine) == null || !((HashMap)HolographicDisplaysImpl.this.holograms.get(cubeletMachine)).containsKey(player.getUniqueId())) continue;
                    Hologram hologram = (Hologram)((HashMap)HolographicDisplaysImpl.this.holograms.get(cubeletMachine)).get(player.getUniqueId());
                    hologram.teleport(cubeletMachine.getLocation().clone().add(0.5, (double)list.size() * 0.32 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
                    for (int i = 0; i < list.size(); ++i) {
                        if (list.get(i).equalsIgnoreCase("%reward_icon%")) continue;
                        ((TextLine)hologram.getLine(i)).setText(list.get(i));
                    }
                }
                this.pointsToShow = this.pointsToShow + this.pointsPerTick <= n ? (this.pointsToShow += this.pointsPerTick) : n;
            }
        };
    }

    @Override
    public void removeHolograms(Player player) {
        for (CubeletMachine cubeletMachine : this.main.getCubeletBoxHandler().getBoxes().values()) {
            if (this.holograms.get(cubeletMachine) == null || !this.holograms.get(cubeletMachine).containsKey(player.getUniqueId()) || this.holograms.get(cubeletMachine).get(player.getUniqueId()) == null) continue;
            this.holograms.get(cubeletMachine).get(player.getUniqueId()).delete();
            this.holograms.get(cubeletMachine).remove(player.getUniqueId());
        }
    }

    @Override
    public void removeHolograms(CubeletMachine cubeletMachine) {
        if (this.holograms.get(cubeletMachine) == null) {
            return;
        }
        for (Hologram hologram : this.holograms.get(cubeletMachine).values()) {
            hologram.delete();
        }
    }
}

