/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.player.crafting;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.enums.CraftType;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.menus.player.crafting.CraftingConfirmationMenu;
import me.davidml16.acubelets.objects.CraftIngredient;
import me.davidml16.acubelets.objects.CraftParent;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.SkullCreator;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CraftingMenu
extends Menu {
    public CraftingMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        Object object;
        ItemStack itemStack;
        Player player = this.getOwner();
        player.updateInventory();
        int n2 = this.getMain().getCubeletCraftingHandler().getInventorySize();
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("crafting");
        Inventory inventory = this.createInventory(n2, gUILayout.getMessage("Title"));
        if (gUILayout.getBoolean("Items.PlayerInfo.Enabled")) {
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.PlayerInfo.Material")).get().parseItem()).toItemStack();
            if (XMaterial.PLAYER_HEAD.parseItem().equals((Object)itemStack)) {
                itemStack = SkullCreator.itemFromUuid(player.getUniqueId());
            }
            object = new ItemBuilder(itemStack).setName(gUILayout.getMessage("Items.PlayerInfo.Name").replaceAll("%player%", player.getName())).setLore(gUILayout.getMessageListPlaceholders(player, "Items.PlayerInfo.Lore")).toItemStack();
            inventory.setItem(n2 - 10 + gUILayout.getSlot("PlayerInfo"), (ItemStack)object);
        }
        itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Back.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Back.Name")).setLore(gUILayout.getMessageList("Items.Back.Lore")).toItemStack();
        inventory.setItem(n2 - 10 + gUILayout.getSlot("Back"), itemStack);
        if (gUILayout.getBoolean("Items.Points.Enabled")) {
            object = new ArrayList();
            for (String string : gUILayout.getMessageList("Items.Points.Lore")) {
                object.add(string.replaceAll("%points_available%", "" + this.getMain().getPlayerDataHandler().getData(player).getLootPoints()));
            }
            ItemStack itemStack2 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Points.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Points.Name")).setLore((List<String>)object).toItemStack();
            inventory.setItem(n2 - 10 + gUILayout.getSlot("Points"), itemStack2);
        }
        for (CraftParent craftParent : this.getMain().getCubeletCraftingHandler().getCrafts()) {
            CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(craftParent.getCubeletType());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : gUILayout.getMessageList("Ingredients.Lore")) {
                if (string.contains("%ingredients%")) {
                    for (CraftIngredient craftIngredient : craftParent.getIngrediens()) {
                        String string2 = this.getMain().getCubeletCraftingHandler().haveIngredient(player, craftIngredient) ? gUILayout.getMessage("Ingredients.Status.Available") : gUILayout.getMessage("Ingredients.Status.NotAvailable");
                        if (craftIngredient.getCraftType() == CraftType.CUBELET) {
                            arrayList.add(Utils.translate(gUILayout.getMessage("Ingredients.Ingredient.Cubelet").replaceAll("%name%", Utils.removeColors(this.getMain().getCubeletTypesHandler().getTypeBydId(craftIngredient.getName()).getName())).replaceAll("%amount%", "" + craftIngredient.getAmount()).replaceAll("%status%", string2)));
                            continue;
                        }
                        if (craftIngredient.getCraftType() == CraftType.MONEY) {
                            arrayList.add(Utils.translate(gUILayout.getMessage("Ingredients.Ingredient.Money").replaceAll("%amount%", "" + craftIngredient.getAmount()).replaceAll("%status%", string2)));
                            continue;
                        }
                        if (craftIngredient.getCraftType() != CraftType.POINTS) continue;
                        arrayList.add(Utils.translate(gUILayout.getMessage("Ingredients.Ingredient.Points").replaceAll("%amount%", "" + craftIngredient.getAmount()).replaceAll("%status%", string2)));
                    }
                    continue;
                }
                if (string.contains("%description%")) {
                    for (String string3 : cubeletType.getDescription()) {
                        arrayList.add(Utils.translate(string3));
                    }
                    continue;
                }
                arrayList.add(Utils.translate(string));
            }
            ItemStack itemStack3 = new ItemBuilder(cubeletType.getIcon()).setName(Utils.translate(cubeletType.getName())).setLore(arrayList).toItemStack();
            itemStack3 = NBTEditor.set(itemStack3, craftParent.getCubeletType(), "cubeletType");
            itemStack3 = NBTEditor.set(itemStack3, Boolean.toString(this.getMain().getCubeletCraftingHandler().haveIngredients(player, craftParent)), "haveIngredients");
            if (craftParent.getIngrediens().size() <= 0 || craftParent.getSlot() > n2 - 10) continue;
            inventory.setItem(craftParent.getSlot(), itemStack3);
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        Player player = this.getOwner();
        int n = this.getMain().getCubeletCraftingHandler().getInventorySize();
        int n2 = inventoryClickEvent.getRawSlot();
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("crafting");
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (n2 >= 0 && n2 <= n - 10) {
            String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "haveIngredients");
            if (string.equalsIgnoreCase("false")) {
                player.sendMessage(this.getMain().getLayoutHandler().getLayout("crafting").getMessage("NoAfford"));
                return;
            }
            String string2 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "cubeletType");
            CraftingConfirmationMenu craftingConfirmationMenu = new CraftingConfirmationMenu(this.getMain(), player);
            craftingConfirmationMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, string2);
            craftingConfirmationMenu.open();
        } else if (n2 == n - 10 + gUILayout.getSlot("Back")) {
            new CubeletsMenu(this.getMain(), player).open();
        }
    }

    @Override
    public void OnMenuClosed() {
    }
}

