/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.objects;

import java.util.HashMap;
import java.util.Map;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.utils.Sounds;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class Menu {
    private Main main;
    private Player owner;
    private Inventory inventory;
    private int page;
    private Map<AttrType, Object> attributes;
    private boolean removeFromOppened;

    public Menu(Main main, Player player) {
        this.main = main;
        this.owner = player;
        this.attributes = new HashMap<AttrType, Object>();
        this.removeFromOppened = true;
    }

    public void open() {
        this.owner.updateInventory();
        this.openPage(0);
    }

    public void openPage(int n) {
        this.page = n;
        this.OnPageOpened(n);
    }

    public void openInventory() {
        this.owner.openInventory(this.inventory);
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> this.main.getMenuHandler().addOpenedMenu(this.owner, this), 1L);
    }

    public Inventory createInventory(int n, String string) {
        this.inventory = Bukkit.createInventory(null, (int)n, (String)string);
        return this.inventory;
    }

    public Inventory createInventory(InventoryType inventoryType, String string) {
        this.inventory = Bukkit.createInventory(null, (InventoryType)inventoryType, (String)string);
        return this.inventory;
    }

    public abstract void OnPageOpened(int var1);

    public abstract void OnMenuClick(InventoryClickEvent var1);

    public abstract void OnMenuClosed();

    public Main getMain() {
        return this.main;
    }

    public void setMain(Main main) {
        this.main = main;
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player player) {
        this.owner = player;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public Map<AttrType, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<AttrType, Object> map) {
        this.attributes = map;
    }

    public Object getAttribute(AttrType attrType) {
        return this.attributes.getOrDefault((Object)attrType, null);
    }

    public void setAttribute(AttrType attrType, Object object) {
        this.attributes.put(attrType, object);
    }

    public boolean isRemoveFromOppened() {
        return this.removeFromOppened;
    }

    public void setRemoveFromOppened(boolean bl) {
        this.removeFromOppened = bl;
    }

    public void reloadMenu() {
        for (Menu menu : this.getMain().getMenuHandler().getOpenedMenus().values()) {
            if (!menu.getClass().equals(this.getClass())) continue;
            menu.openPage(menu.getPage());
        }
    }

    public void reloadMyMenu() {
        this.openPage(this.page);
    }

    public void fillBorders(ItemStack itemStack) {
        int n;
        int n2 = this.inventory.getSize();
        int n3 = (n2 + 1) / 9;
        for (n = 0; n < 9; ++n) {
            this.inventory.setItem(n, itemStack);
        }
        for (n = n2 - 9; n < n2; ++n) {
            this.inventory.setItem(n, itemStack);
        }
        for (n = 2; n <= n3 - 1; ++n) {
            int[] nArray = new int[]{n * 9 - 1, (n - 1) * 9};
            this.inventory.setItem(nArray[0], itemStack);
            this.inventory.setItem(nArray[1], itemStack);
        }
    }

    public void fillTopSide(ItemStack itemStack, int n) {
        int n2;
        for (n2 = 0; n2 < 9; ++n2) {
            this.inventory.setItem(n2, itemStack);
        }
        for (n2 = 2; n2 <= n; ++n2) {
            int[] nArray = new int[]{n2 * 9 - 1, (n2 - 1) * 9};
            this.inventory.setItem(nArray[0], itemStack);
            this.inventory.setItem(nArray[1], itemStack);
        }
    }

    public void fillPage(ItemStack itemStack) {
        int n = this.inventory.getSize();
        for (int i = 0; i < n; ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, itemStack);
        }
    }

    public void previousPage() {
        if (this.page == 0) {
            return;
        }
        --this.page;
        this.openPage(this.page);
    }

    public void nextPage() {
        ++this.page;
        this.openPage(this.page);
    }

    public void playSound(SoundType soundType) {
        switch (soundType) {
            case CLICK: {
                Sounds.playSound(this.owner, this.owner.getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
                break;
            }
            case CHICKEN_EGG_POP: {
                Sounds.playSound(this.owner, this.owner.getLocation(), Sounds.MySound.CHICKEN_EGG_POP, 10.0f, 3.0f);
                break;
            }
            case ANVIL_USE: {
                Sounds.playSound(this.owner, this.owner.getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                break;
            }
            case NOTE_PLING: {
                Sounds.playSound(this.owner, this.owner.getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 3.0f);
            }
        }
    }

    public static enum SoundType {
        CLICK,
        CHICKEN_EGG_POP,
        ANVIL_USE,
        NOTE_PLING;

    }

    public static enum AttrType {
        CUBELET_TYPE_ATTR,
        CUBELET_DISPLAYED_LIST_ATTR,
        CUBELET_DISPLAYED_ITEMS_ATTR,
        CUBELET_BOX_ATTR,
        CUSTOM_ID_ATTR,
        CRAFT_PARENT_ATTR,
        GIFT_GUISESSION_ATTR,
        ANIMATION_SETTINGS_ATTR,
        REWARD_ATTR,
        OPENED_EXTERNALLY_ATTR;

    }
}

