/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.jsoup.UncheckedIOException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.ConstrainableInputStream;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Parser;

public final class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:[\"'])?([^\\s,;\"']*)");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    static final String defaultCharsetName = UTF_8.name();
    private static final int firstReadBufferSize = 5120;
    static final int bufferSize = 32768;
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final int boundaryLength = 32;

    private DataUtil() {
    }

    public static Document load(File file, @Nullable String string, String string2) {
        return DataUtil.load(file, string, string2, Parser.htmlParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document load(File file, @Nullable String string, String string2, Parser parser) {
        InputStream inputStream = new FileInputStream(file);
        String string3 = Normalizer.lowerCase(file.getName());
        if (string3.endsWith(".gz") || string3.endsWith(".z")) {
            boolean bl;
            try {
                bl = ((InputStream)inputStream).read() == 31 && ((InputStream)inputStream).read() == 139;
            }
            finally {
                ((InputStream)inputStream).close();
            }
            inputStream = bl ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        }
        return DataUtil.parseInputStream(inputStream, string, string2, parser);
    }

    public static Document load(@WillClose InputStream inputStream, @Nullable String string, String string2) {
        return DataUtil.parseInputStream(inputStream, string, string2, Parser.htmlParser());
    }

    public static Document load(@WillClose InputStream inputStream, @Nullable String string, String string2, Parser parser) {
        return DataUtil.parseInputStream(inputStream, string, string2, parser);
    }

    static void crossStreams(InputStream inputStream, OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Document parseInputStream(@Nullable @WillClose InputStream inputStream, @Nullable String string, String string2, Parser parser) {
        Document document;
        block28: {
            if (inputStream == null) {
                return new Document(string2);
            }
            inputStream = ConstrainableInputStream.wrap(inputStream, 32768, 0);
            document = null;
            try {
                Object object;
                inputStream.mark(32768);
                ByteBuffer byteBuffer = DataUtil.readToByteBuffer(inputStream, 5119);
                boolean bl = inputStream.read() == -1;
                inputStream.reset();
                BomCharset bomCharset = DataUtil.detectCharsetFromBom(byteBuffer);
                if (bomCharset != null) {
                    string = bomCharset.charset;
                }
                if (string == null) {
                    Node node;
                    try {
                        object = UTF_8.decode(byteBuffer);
                        document = ((CharBuffer)object).hasArray() ? parser.parseInput(new CharArrayReader(((CharBuffer)object).array(), ((CharBuffer)object).arrayOffset(), ((Buffer)object).limit()), string2) : parser.parseInput(((CharBuffer)object).toString(), string2);
                    }
                    catch (UncheckedIOException uncheckedIOException) {
                        throw uncheckedIOException.ioException();
                    }
                    object = document.select("meta[http-equiv=content-type], meta[charset]");
                    String string3 = null;
                    Object object2 = ((ArrayList)object).iterator();
                    while (object2.hasNext()) {
                        node = (Element)object2.next();
                        if (node.hasAttr("http-equiv")) {
                            string3 = DataUtil.getCharsetFromContentType(node.attr("content"));
                        }
                        if (string3 == null && node.hasAttr("charset")) {
                            string3 = node.attr("charset");
                        }
                        if (string3 == null) continue;
                        break;
                    }
                    if (string3 == null && document.childNodeSize() > 0) {
                        Comment comment;
                        object2 = document.childNode(0);
                        node = null;
                        if (object2 instanceof XmlDeclaration) {
                            node = (XmlDeclaration)object2;
                        } else if (object2 instanceof Comment && (comment = (Comment)object2).isXmlDeclaration()) {
                            node = comment.asXmlDeclaration();
                        }
                        if (node != null && ((XmlDeclaration)node).name().equalsIgnoreCase("xml")) {
                            string3 = ((XmlDeclaration)node).attr("encoding");
                        }
                    }
                    if ((string3 = DataUtil.validateCharset(string3)) != null && !string3.equalsIgnoreCase(defaultCharsetName)) {
                        string = string3 = string3.trim().replaceAll("[\"']", "");
                        document = null;
                    } else if (!bl) {
                        document = null;
                    }
                } else {
                    Validate.notEmpty(string, "Must set charset arg to character set of file to parse. Set to null to attempt to detect from HTML");
                }
                if (document != null) break block28;
                if (string == null) {
                    string = defaultCharsetName;
                }
                object = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(string)), 32768);
                try {
                    if (bomCharset != null && bomCharset.offset) {
                        long l = ((BufferedReader)object).skip(1L);
                        Validate.isTrue(l == 1L);
                    }
                    try {
                        document = parser.parseInput((Reader)object, string2);
                    }
                    catch (UncheckedIOException uncheckedIOException) {
                        throw uncheckedIOException.ioException();
                    }
                    Charset charset = string.equals(defaultCharsetName) ? UTF_8 : Charset.forName(string);
                    document.outputSettings().charset(charset);
                    if (!charset.canEncode()) {
                        document.charset(UTF_8);
                    }
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        return document;
    }

    public static ByteBuffer readToByteBuffer(InputStream inputStream, int n) {
        Validate.isTrue(n >= 0, "maxSize must be 0 (unlimited) or larger");
        ConstrainableInputStream constrainableInputStream = ConstrainableInputStream.wrap(inputStream, 32768, n);
        return constrainableInputStream.readToByteBuffer(n);
    }

    static ByteBuffer emptyByteBuffer() {
        return ByteBuffer.allocate(0);
    }

    @Nullable
    static String getCharsetFromContentType(@Nullable String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = charsetPattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1).trim();
            string2 = string2.replace("charset=", "");
            return DataUtil.validateCharset(string2);
        }
        return null;
    }

    @Nullable
    private static String validateCharset(@Nullable String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.trim().replaceAll("[\"']", "");
        try {
            if (Charset.isSupported(string)) {
                return string;
            }
            if (Charset.isSupported(string = string.toUpperCase(Locale.ENGLISH))) {
                return string;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return null;
    }

    static String mimeBoundary() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        Random random = new Random();
        for (int i = 0; i < 32; ++i) {
            stringBuilder.append(mimeBoundaryChars[random.nextInt(mimeBoundaryChars.length)]);
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    @Nullable
    private static BomCharset detectCharsetFromBom(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        ((Buffer)byteBuffer2).mark();
        byte[] byArray = new byte[4];
        if (byteBuffer.remaining() >= byArray.length) {
            byteBuffer.get(byArray);
            ((Buffer)byteBuffer2).rewind();
        }
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1 || byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            return new BomCharset("UTF-32", false);
        }
        if (byArray[0] == -2 && byArray[1] == -1 || byArray[0] == -1 && byArray[1] == -2) {
            return new BomCharset("UTF-16", false);
        }
        if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return new BomCharset("UTF-8", true);
        }
        return null;
    }

    private static class BomCharset {
        private final String charset;
        private final boolean offset;

        public BomCharset(String string, boolean bl) {
            this.charset = string;
            this.offset = bl;
        }
    }
}

