/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.google.common.base.Enums;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public enum XEnchantment {
    ARROW_DAMAGE("POWER", "ARROW_DAMAGE", "ARROW_POWER", "AD"),
    ARROW_FIRE("FLAME", "FLAME_ARROW", "FIRE_ARROW", "AF"),
    ARROW_INFINITE("INFINITY", "INF_ARROWS", "INFINITE_ARROWS", "INFINITE", "UNLIMITED", "UNLIMITED_ARROWS", "AI"),
    ARROW_KNOCKBACK("PUNCH", "ARROW_KNOCKBACK", "ARROWKB", "ARROW_PUNCH", "AK"),
    BINDING_CURSE(true, "BINDING_CURSE", "BIND_CURSE", "BINDING", "BIND"),
    CHANNELING(true, "CHANNELLING", "CHANELLING", "CHANELING", "CHANNEL"),
    DAMAGE_ALL("SHARPNESS", "ALL_DAMAGE", "ALL_DMG", "SHARP", "DAL"),
    DAMAGE_ARTHROPODS("BANE_OF_ARTHROPODS", "ARDMG", "BANE_OF_ARTHROPOD", "ARTHROPOD", "DAR"),
    DAMAGE_UNDEAD("SMITE", "UNDEAD_DAMAGE", "DU"),
    DEPTH_STRIDER(true, "DEPTH", "STRIDER"),
    DIG_SPEED("EFFICIENCY", "MINE_SPEED", "CUT_SPEED", "DS", "EFF"),
    DURABILITY("UNBREAKING", "DURA"),
    FIRE_ASPECT(true, "FIRE", "MELEE_FIRE", "MELEE_FLAME", "FA"),
    FROST_WALKER(true, "FROST", "WALKER"),
    IMPALING(true, "IMPALE", "OCEAN_DAMAGE", "OCEAN_DMG"),
    KNOCKBACK(true, "K_BACK", "KB"),
    LOOT_BONUS_BLOCKS("FORTUNE", "BLOCKS_LOOT_BONUS", "FORT", "LBB"),
    LOOT_BONUS_MOBS("LOOTING", "MOB_LOOT", "MOBS_LOOT_BONUS", "LBM"),
    LOYALTY(true, "LOYAL", "RETURN"),
    LUCK("LUCK_OF_THE_SEA", "LUCK_OF_SEA", "LUCK_OF_SEAS", "ROD_LUCK"),
    LURE(true, "ROD_LURE"),
    MENDING(true, new String[0]),
    MULTISHOT(true, "TRIPLE_SHOT"),
    OXYGEN("RESPIRATION", "BREATH", "BREATHING", "O2", "O"),
    PIERCING(true, new String[0]),
    PROTECTION_ENVIRONMENTAL("PROTECTION", "PROTECT", "PROT"),
    PROTECTION_EXPLOSIONS("BLAST_PROTECTION", "BLAST_PROTECT", "EXPLOSIONS_PROTECTION", "EXPLOSION_PROTECTION", "BLAST_PROTECTION", "PE"),
    PROTECTION_FALL("FEATHER_FALLING", "FALL_PROT", "FEATHER_FALL", "FALL_PROTECTION", "FEATHER_FALLING", "PFA"),
    PROTECTION_FIRE("FIRE_PROTECTION", "FIRE_PROT", "FIRE_PROTECT", "FIRE_PROTECTION", "FLAME_PROTECTION", "FLAME_PROTECT", "FLAME_PROT", "PF"),
    PROTECTION_PROJECTILE("PROJECTILE_PROTECTION", "PROJECTILE_PROTECTION", "PROJ_PROT", "PP"),
    QUICK_CHARGE(true, "QUICKCHARGE", "QUICK_DRAW", "FAST_CHARGE", "FAST_DRAW"),
    RIPTIDE(true, "RIP", "TIDE", "LAUNCH"),
    SILK_TOUCH(true, "SOFT_TOUCH", "ST"),
    SOUL_SPEED(true, "SPEED_SOUL", "SOUL_RUNNER"),
    SWEEPING_EDGE("SWEEPING", "SWEEPING_EDGE", "SWEEP_EDGE"),
    SWIFT_SNEAK(true, "SNEAK_SWIFT"),
    THORNS(true, "HIGHCRIT", "THORN", "HIGHERCRIT", "T"),
    VANISHING_CURSE(true, "VANISHING_CURSE", "VANISH_CURSE", "VANISHING", "VANISH"),
    WATER_WORKER("AQUA_AFFINITY", "WATER_WORKER", "AQUA_AFFINITY", "WATER_MINE", "WW");

    public static final XEnchantment[] VALUES;
    public static final Set<EntityType> EFFECTIVE_SMITE_ENTITIES;
    public static final Set<EntityType> EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES;
    @Nullable
    private final Enchantment enchantment;

    private XEnchantment(String ... stringArray) {
        this(false, stringArray);
    }

    private XEnchantment(boolean bl, String ... enchantment) {
        Enchantment enchantment2;
        Data.NAMES.put(this.name(), this);
        for (String string2 : enchantment) {
            Data.NAMES.put(string2, this);
        }
        if (Data.ISFLAT) {
            String string3 = bl ? this.name() : enchantment[0];
            enchantment2 = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)string3.toLowerCase(Locale.ENGLISH)));
        } else {
            enchantment2 = Enchantment.getByName((String)this.name());
        }
        this.enchantment = enchantment2;
    }

    public static boolean isSmiteEffectiveAgainst(@Nullable EntityType entityType) {
        return entityType != null && EFFECTIVE_SMITE_ENTITIES.contains(entityType);
    }

    public static boolean isArthropodsEffectiveAgainst(@Nullable EntityType entityType) {
        return entityType != null && EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES.contains(entityType);
    }

    @Nonnull
    private static String format(@Nonnull String string) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(bl || n2 == 0 || c != '-' && c != ' ' && c != '_' || cArray[n2] == '_')) {
                bl = true;
                continue;
            }
            if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
            if (bl) {
                cArray[n2++] = 95;
                bl = false;
            }
            cArray[n2++] = (char)(c & 0x5F);
        }
        return new String(cArray, 0, n2);
    }

    @Nonnull
    public static Optional<XEnchantment> matchXEnchantment(@Nonnull String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Enchantment name cannot be null or empty");
        }
        return Optional.ofNullable((XEnchantment)((Object)Data.NAMES.get(XEnchantment.format(string))));
    }

    @Nonnull
    public static XEnchantment matchXEnchantment(@Nonnull Enchantment enchantment) {
        Objects.requireNonNull(enchantment, "Cannot parse XEnchantment of a null enchantment");
        return Objects.requireNonNull((XEnchantment)((Object)Data.NAMES.get(enchantment.getName())), () -> "Unsupported enchantment: " + enchantment.getName());
    }

    @Nonnull
    public ItemStack getBook(int n) {
        ItemStack itemStack = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemStack.getItemMeta();
        enchantmentStorageMeta.addStoredEnchant(this.enchantment, n, true);
        itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        return itemStack;
    }

    @Nullable
    public Enchantment getEnchant() {
        return this.enchantment;
    }

    public boolean isSupported() {
        return this.enchantment != null;
    }

    @Nonnull
    public String toString() {
        return Arrays.stream(this.name().split("_")).map(string -> string.charAt(0) + string.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    static {
        VALUES = XEnchantment.values();
        EntityType entityType = (EntityType)Enums.getIfPresent(EntityType.class, (String)"BEE").orNull();
        EntityType entityType2 = (EntityType)Enums.getIfPresent(EntityType.class, (String)"PHANTOM").orNull();
        EntityType entityType3 = (EntityType)Enums.getIfPresent(EntityType.class, (String)"DROWNED").orNull();
        EntityType entityType4 = (EntityType)Enums.getIfPresent(EntityType.class, (String)"WITHER_SKELETON").orNull();
        EntityType entityType5 = (EntityType)Enums.getIfPresent(EntityType.class, (String)"SKELETON_HORSE").orNull();
        EntityType entityType6 = (EntityType)Enums.getIfPresent(EntityType.class, (String)"STRAY").orNull();
        EntityType entityType7 = (EntityType)Enums.getIfPresent(EntityType.class, (String)"HUSK").orNull();
        EnumSet<EntityType> enumSet = EnumSet.of(EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.SILVERFISH, EntityType.ENDERMITE);
        if (entityType != null) {
            enumSet.add(entityType);
        }
        EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES = Collections.unmodifiableSet(enumSet);
        EnumSet<EntityType> enumSet2 = EnumSet.of(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.WITHER);
        if (entityType2 != null) {
            enumSet2.add(entityType2);
        }
        if (entityType3 != null) {
            enumSet2.add(entityType3);
        }
        if (entityType4 != null) {
            enumSet2.add(entityType4);
        }
        if (entityType5 != null) {
            enumSet2.add(entityType5);
        }
        if (entityType6 != null) {
            enumSet2.add(entityType6);
        }
        if (entityType7 != null) {
            enumSet2.add(entityType7);
        }
        EFFECTIVE_SMITE_ENTITIES = Collections.unmodifiableSet(enumSet2);
    }

    private static final class Data {
        private static final boolean ISFLAT;
        private static final Map<String, XEnchantment> NAMES;

        private Data() {
        }

        static {
            boolean bl;
            NAMES = new HashMap<String, XEnchantment>();
            try {
                Class<?> clazz = Class.forName("org.bukkit.NamespacedKey");
                Class<?> clazz2 = Class.forName("org.bukkit.enchantments.Enchantment");
                clazz2.getDeclaredMethod("getByKey", clazz);
                bl = true;
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                bl = false;
            }
            ISFLAT = bl;
        }
    }
}

