/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.commands.cubelets.subcommands;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.admin.EditMachineMenu;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ExecuteBox {
    private Main main;

    public ExecuteBox(Main main) {
        this.main = main;
    }

    public boolean executeCommand(CommandSender commandSender, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(Utils.translate("&cThe commands only can be use by players!"));
            return true;
        }
        if (!this.main.playerHasPermission((Player)commandSender, "acubelets.admin")) {
            commandSender.sendMessage(this.main.getLanguageHandler().getMessage("Commands.NoPerms"));
            return false;
        }
        if (stringArray.length == 1) {
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " machine [create/remove/edit]"));
            commandSender.sendMessage("");
            return false;
        }
        if (stringArray[1].equalsIgnoreCase("create")) {
            Block block = ((Player)commandSender).getTargetBlock(null, 5);
            if (block.getType().isBlock() && block.getType() != Material.AIR) {
                if (!this.main.getCubeletBoxHandler().getBoxes().containsKey(block.getLocation())) {
                    ArmorStand armorStand = (ArmorStand)block.getLocation().getWorld().spawn(block.getLocation().clone().add(0.5, 1.5, 0.5), ArmorStand.class);
                    armorStand.setVisible(false);
                    armorStand.setGravity(true);
                    armorStand.setSmall(false);
                    armorStand.setRemoveWhenFarAway(false);
                    Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> armorStand.setVelocity(new Vector(0, -10, 0)), 1L);
                    Sounds.playSound((Player)commandSender, ((Player)commandSender).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                    commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &aSuccesfully " + string + " new cubelet machine on &aX: &e" + block.getLocation().getBlockX() + ", &aY: &e" + block.getLocation().getBlockY() + ", &aZ: &e" + block.getLocation().getBlockZ()));
                    Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
                        double d = armorStand.getLocation().getY() - (double)block.getLocation().getBlockY();
                        this.main.getCubeletBoxHandler().createBox(block.getLocation(), d);
                        armorStand.remove();
                    }, 10L);
                    return true;
                }
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThis " + string + " machine location already exists!"));
                return false;
            }
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cA " + string + " machine needs to be a block!"));
            return false;
        }
        if (stringArray[1].equalsIgnoreCase("remove")) {
            Block block = ((Player)commandSender).getTargetBlock(null, 5);
            if (block.getType().isBlock() && block.getType() != Material.AIR) {
                if (this.main.getCubeletBoxHandler().getBoxes().containsKey(block.getLocation())) {
                    this.main.getCubeletBoxHandler().removeBox(block.getLocation());
                    Sounds.playSound((Player)commandSender, ((Player)commandSender).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                    commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &aSuccesfully removed " + string + " machine of &aX: &e" + block.getLocation().getBlockX() + ", &aY: &e" + block.getLocation().getBlockY() + ", &aZ: &e" + block.getLocation().getBlockZ()));
                    return true;
                }
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThis " + string + " machine location no exists!"));
                return false;
            }
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cA " + string + " machine needs to be a block!"));
            return false;
        }
        if (stringArray[1].equalsIgnoreCase("edit")) {
            Block block = ((Player)commandSender).getTargetBlock(null, 5);
            if (block.getType().isBlock() && block.getType() != Material.AIR) {
                if (this.main.getCubeletBoxHandler().getBoxes().containsKey(block.getLocation())) {
                    EditMachineMenu editMachineMenu = new EditMachineMenu(this.main, (Player)commandSender);
                    editMachineMenu.setAttribute(Menu.AttrType.CUBELET_BOX_ATTR, this.main.getCubeletBoxHandler().getBoxByLocation(block.getLocation()));
                    editMachineMenu.open();
                    return true;
                }
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThis " + string + " machine location no exists!"));
                return false;
            }
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cA " + string + " machine needs to be a block!"));
            return false;
        }
        return true;
    }
}

