/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation.rewards;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.rewards.EditRewardPermissionsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.rewards.PermissionObject;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PermissionObjectRewardConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public PermissionObjectRewardConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CubeletType cubeletType, Reward reward) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RewardMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"reward", (Object)reward);
        conversation.getContext().setSessionData((Object)"cubeletType", (Object)cubeletType);
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    public class RewardMenuOptions
    extends FixedSetPrompt {
        RewardMenuOptions() {
            super(new String[]{"1", "2", "3"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            CubeletType cubeletType = (CubeletType)conversationContext.getSessionData((Object)"cubeletType");
            switch (string) {
                case "1": {
                    return new CommonPrompts.CommonStringPrompt(PermissionObjectRewardConversation.this.main, (Prompt)this, true, ChatColor.YELLOW + "  Enter reward permission, \"cancel\" to return.\n\n ", "rewardPermission");
                }
                case "2": {
                    if (conversationContext.getSessionData((Object)"rewardPermission") != null) {
                        String string2 = (String)conversationContext.getSessionData((Object)"rewardPermission");
                        Reward reward = (Reward)conversationContext.getSessionData((Object)"reward");
                        reward.getPermissions().add(new PermissionObject("permission-" + reward.getPermissions().size(), string2));
                        cubeletType.saveType();
                        conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(PermissionObjectRewardConversation.this.main.getLanguageHandler().getPrefix() + " &aYou added &e" + reward.getId() + " &ato permissions of cubelet type &e" + cubeletType.getId()));
                        Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                        PermissionObjectRewardConversation.this.main.getMenuHandler().reloadAllMenus(EditRewardPermissionsMenu.class);
                        Player player = (Player)conversationContext.getSessionData((Object)"player");
                        EditRewardPermissionsMenu editRewardPermissionsMenu = new EditRewardPermissionsMenu(PermissionObjectRewardConversation.this.main, player);
                        editRewardPermissionsMenu.setAttribute(Menu.AttrType.REWARD_ATTR, reward);
                        editRewardPermissionsMenu.open();
                        PermissionObjectRewardConversation.this.main.getConversationHandler().removeConversation(player);
                        return Prompt.END_OF_CONVERSATION;
                    }
                    return new CommonPrompts.ErrorPrompt(PermissionObjectRewardConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  You need to setup PERMISSION to save command reward!\n  Write anything to continue\n ");
                }
                case "3": {
                    return new CommonPrompts.ConfirmExitPrompt(PermissionObjectRewardConversation.this.main, (Prompt)this);
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET PERMISSION REWARD CREATION MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = conversationContext.getSessionData((Object)"rewardPermission") == null ? string + ChatColor.RED + "    1 " + ChatColor.GRAY + "- Set reward permission (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Set reward permission (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"rewardPermission") + ChatColor.GRAY + ")\n";
            string = string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Save\n";
            string = string + ChatColor.GREEN + "    3 " + ChatColor.GRAY + "- Exit and discard\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

