/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation.rewards;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.rewards.RewardsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RewardConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public RewardConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CubeletType cubeletType) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RewardMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"cubeletType", (Object)cubeletType);
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    private boolean rewardsIdExist(CubeletType cubeletType, String string) {
        for (Reward reward : cubeletType.getAllRewards()) {
            if (!reward.getId().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public class RewardMenuOptions
    extends FixedSetPrompt {
        RewardMenuOptions() {
            super(new String[]{"1", "2", "3", "4", "5"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            CubeletType cubeletType = (CubeletType)conversationContext.getSessionData((Object)"cubeletType");
            Player player = (Player)conversationContext.getSessionData((Object)"player");
            ItemStack itemStack = player.getInventory().getItemInHand();
            switch (string) {
                case "1": {
                    return new CommonPrompts.UncoloredStringPrompt(RewardConversation.this.main, (Prompt)this, true, ChatColor.YELLOW + "  Enter reward name, \"cancel\" to return.\n\n ", "rewardName");
                }
                case "2": {
                    return new CommonPrompts.CommonStringPrompt(RewardConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter reward rarity, \"cancel\" to return.\n  Available rarities: " + cubeletType.getRaritiesIDs() + "\n\n ", "rewardRarity");
                }
                case "3": {
                    if (itemStack == null || itemStack.getType() == Material.AIR) {
                        conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  AIR icon not allowed!\n ");
                        Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                        return this;
                    }
                    conversationContext.setSessionData((Object)"rewardIcon", (Object)itemStack.clone());
                    conversationContext.getForWhom().sendRawMessage(ChatColor.GREEN + "  Succesfully setup reward icon.");
                    Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
                    return this;
                }
                case "4": {
                    if (conversationContext.getSessionData((Object)"rewardName") != null && conversationContext.getSessionData((Object)"rewardRarity") != null && conversationContext.getSessionData((Object)"rewardIcon") != null) {
                        if (cubeletType.getRarities().containsKey((String)conversationContext.getSessionData((Object)"rewardRarity"))) {
                            if (!RewardConversation.this.rewardsIdExist(cubeletType, (String)conversationContext.getSessionData((Object)"rewardID"))) {
                                String string2 = "reward_" + cubeletType.getAllRewards().size();
                                String string3 = (String)conversationContext.getSessionData((Object)"rewardName");
                                String string4 = (String)conversationContext.getSessionData((Object)"rewardRarity");
                                ItemStack itemStack2 = (ItemStack)conversationContext.getSessionData((Object)"rewardIcon");
                                Reward reward = new Reward(string2, string3, cubeletType.getRarities().get(string4), itemStack2.clone(), cubeletType);
                                cubeletType.addReward(string4, reward);
                                cubeletType.saveType();
                                conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(RewardConversation.this.main.getLanguageHandler().getPrefix() + " &aYou added reward &e" + reward.getId() + " &ato rewards of cubelet type &e" + cubeletType.getId()));
                                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                                RewardConversation.this.main.getMenuHandler().reloadAllMenus(RewardsMenu.class);
                                Player player2 = (Player)conversationContext.getSessionData((Object)"player");
                                RewardsMenu rewardsMenu = new RewardsMenu(RewardConversation.this.main, player2);
                                rewardsMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                                rewardsMenu.open();
                                RewardConversation.this.main.getConversationHandler().removeConversation(player2);
                                return Prompt.END_OF_CONVERSATION;
                            }
                            return new CommonPrompts.ErrorPrompt(RewardConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  There is already a reward with that ID, please change it and try again\n  Write anything to continue\n ");
                        }
                        return new CommonPrompts.ErrorPrompt(RewardConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  This reward rarity not exist, please change it and try again\n  Write anything to continue\n ");
                    }
                    return new CommonPrompts.ErrorPrompt(RewardConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  You need to setup ID, NAME, RARITY, ITEM and ICON to save reward!\n  Write anything to continue\n ");
                }
                case "5": {
                    return new CommonPrompts.ConfirmExitPrompt(RewardConversation.this.main, (Prompt)this);
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET REWARD CREATION MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = conversationContext.getSessionData((Object)"rewardName") == null ? string + ChatColor.RED + "    1 " + ChatColor.GRAY + "- Set reward name (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Set reward name (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"rewardName") + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"rewardRarity") == null ? string + ChatColor.RED + "    2 " + ChatColor.GRAY + "- Set reward rarity (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Set reward rarity (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)((String)conversationContext.getSessionData((Object)"rewardRarity"))) + ChatColor.GRAY + ")\n";
            if (conversationContext.getSessionData((Object)"rewardIcon") == null) {
                string = string + ChatColor.RED + "    3 " + ChatColor.GRAY + "- Set reward icon 'Item in Hand' (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n";
            } else {
                ItemStack itemStack = (ItemStack)conversationContext.getSessionData((Object)"rewardIcon");
                string = string + ChatColor.GREEN + "    3 " + ChatColor.GRAY + "- Set reward icon 'Item in Hand' (" + ChatColor.YELLOW + itemStack.getType().name() + ChatColor.GRAY + ")\n";
            }
            string = string + ChatColor.GREEN + "    4 " + ChatColor.GRAY + "- Save\n";
            string = string + ChatColor.GREEN + "    5 " + ChatColor.GRAY + "- Exit and discard\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

