/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.options;

import com.cryptomorin.xseries.XMaterial;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.conversation.options.RenameAnimationConversation;
import me.davidml16.acubelets.menus.admin.options.OptionsAnimationsMenu;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OptionsAnimationMenu
extends Menu {
    public OptionsAnimationMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        AnimationSettings animationSettings = (AnimationSettings)this.getAttribute(Menu.AttrType.ANIMATION_SETTINGS_ATTR);
        Inventory inventory = this.createInventory(45, "Options | " + animationSettings.getId());
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        inventory.setItem(40, new ItemBuilder(XMaterial.BOOK.parseItem()).setName(Utils.translate("&aBack to animations")).toItemStack());
        this.fillPage(itemStack);
        if (animationSettings.isEnabled()) {
            inventory.setItem(10, new ItemBuilder(XMaterial.LIME_DYE.parseItem()).setName(Utils.translate("&aToggle enabled status")).setLore("", Utils.translate(" &7Toggle if the animation is "), Utils.translate(" &7enable, and visible in menus. "), "", Utils.translate(" &7Status: &aEnabled "), "", Utils.translate("&eClick to disable! ")).toItemStack());
        } else {
            inventory.setItem(10, new ItemBuilder(XMaterial.RED_DYE.parseItem()).setName(Utils.translate("&aToggle enabled status")).setLore("", Utils.translate(" &7Toggle if the animation is "), Utils.translate(" &7enable, and visible in menus. "), "", Utils.translate(" &7Status: &cDisabled "), "", Utils.translate("&eClick to enable! ")).toItemStack());
        }
        if (animationSettings.isNeedPermission()) {
            inventory.setItem(19, new ItemBuilder(XMaterial.LIME_DYE.parseItem()).setName(Utils.translate("&aToggle require permission")).setLore("", Utils.translate(" &7Toggle if the animation "), Utils.translate(" &7require permission to use it. "), "", Utils.translate(" &7Status: &aEnabled "), "", Utils.translate("&eClick to disable! ")).toItemStack());
        } else {
            inventory.setItem(19, new ItemBuilder(XMaterial.RED_DYE.parseItem()).setName(Utils.translate("&aToggle require permission")).setLore("", Utils.translate(" &7Toggle if the animation "), Utils.translate(" &7require permission to use it. "), "", Utils.translate(" &7Status: &cDisabled "), "", Utils.translate("&eClick to enable! ")).toItemStack());
        }
        if (animationSettings.isOutlineParticles()) {
            inventory.setItem(12, new ItemBuilder(XMaterial.LIME_DYE.parseItem()).setName(Utils.translate("&aToggle outline particles")).setLore("", Utils.translate(" &7Toggle if the animation "), Utils.translate(" &7show particles outlining the box. "), "", Utils.translate(" &7Status: &aEnabled "), "", Utils.translate("&eClick to disable! ")).toItemStack());
        } else {
            inventory.setItem(12, new ItemBuilder(XMaterial.RED_DYE.parseItem()).setName(Utils.translate("&aToggle outline particles")).setLore("", Utils.translate(" &7Toggle if the animation "), Utils.translate(" &7show particles outlining the box. "), "", Utils.translate(" &7Status: &cDisabled "), "", Utils.translate("&eClick to enable! ")).toItemStack());
        }
        if (animationSettings.isFloorParticles()) {
            inventory.setItem(22, new ItemBuilder(XMaterial.LIME_DYE.parseItem()).setName(Utils.translate("&aToggle floor particles")).setLore("", Utils.translate(" &7Toggle if the animation "), Utils.translate(" &7show particles in the floor. "), "", Utils.translate(" &7Status: &aEnabled "), "", Utils.translate("&eClick to disable! ")).toItemStack());
        } else {
            inventory.setItem(22, new ItemBuilder(XMaterial.RED_DYE.parseItem()).setName(Utils.translate("&aToggle floor particles")).setLore("", Utils.translate(" &7Toggle if the animation "), Utils.translate(" &7show particles in the floor. "), "", Utils.translate(" &7Status: &cDisabled "), "", Utils.translate("&eClick to enable! ")).toItemStack());
        }
        if (animationSettings.isAroundParticles()) {
            inventory.setItem(14, new ItemBuilder(XMaterial.LIME_DYE.parseItem()).setName(Utils.translate("&aToggle around particles")).setLore("", Utils.translate(" &7Toggle if the animation "), Utils.translate(" &7show particles around the box. "), Utils.translate(" &7Only for some animations. "), "", Utils.translate(" &7Status: &aEnabled "), "", Utils.translate("&eClick to disable! ")).toItemStack());
        } else {
            inventory.setItem(14, new ItemBuilder(XMaterial.RED_DYE.parseItem()).setName(Utils.translate("&aToggle around particles")).setLore("", Utils.translate(" &7Toggle if the animation "), Utils.translate(" &7show particles around the box. "), Utils.translate(" &7Only for some animations. "), "", Utils.translate(" &7Status: &cDisabled "), "", Utils.translate("&eClick to enable! ")).toItemStack());
        }
        inventory.setItem(16, new ItemBuilder(animationSettings.getDisplayItem().clone()).hideAttributes().setName(Utils.translate("&aChange animation icon")).setLore("", Utils.translate(" &7Click an item from your "), Utils.translate(" &7bottom inventory to "), Utils.translate(" &7change the icon. "), "").toItemStack());
        inventory.setItem(25, new ItemBuilder(XMaterial.NAME_TAG.parseItem()).setName(Utils.translate("&aChange animation display name")).setLore("", Utils.translate(" &7Change the display name "), Utils.translate(" &7showed in some menus. "), "", Utils.translate("&eClick to edit! ")).toItemStack());
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        int n = inventoryClickEvent.getRawSlot();
        Player player = this.getOwner();
        AnimationSettings animationSettings = (AnimationSettings)this.getAttribute(Menu.AttrType.ANIMATION_SETTINGS_ATTR);
        if (animationSettings == null) {
            return;
        }
        if (n == 10) {
            animationSettings.setEnabled(!animationSettings.isEnabled());
            this.reloadMenu();
        } else if (n == 19) {
            animationSettings.setNeedPermission(!animationSettings.isNeedPermission());
            this.reloadMenu();
        } else if (n == 12) {
            animationSettings.setOutlineParticles(!animationSettings.isOutlineParticles());
            this.reloadMenu();
        } else if (n == 22) {
            animationSettings.setFloorParticles(!animationSettings.isFloorParticles());
            this.reloadMenu();
        } else if (n == 14) {
            animationSettings.setAroundParticles(!animationSettings.isAroundParticles());
            this.reloadMenu();
        } else if (n == 25) {
            player.closeInventory();
            new RenameAnimationConversation(this.getMain()).getConversation(player, animationSettings).begin();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 40) {
            new OptionsAnimationsMenu(this.getMain(), player).open();
        } else if (n >= 45 && n <= 80) {
            if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            ItemStack itemStack = inventoryClickEvent.getCurrentItem();
            animationSettings.setDisplayItem(itemStack);
            this.reloadMenu();
        }
        this.getMain().getAnimationHandler().saveAnimations();
    }

    @Override
    public void OnMenuClosed() {
    }
}

