/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.tasks;

import java.util.ArrayList;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.objects.Cubelet;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.TimeAPI.TimeUtils;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LiveGuiTask {
    private int id;
    private Main main;

    public LiveGuiTask(Main main) {
        this.main = main;
    }

    public int getId() {
        return this.id;
    }

    public void start() {
        this.id = Bukkit.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this.main, (Runnable)new Task(), 0L, 20L);
    }

    public void stop() {
        Bukkit.getServer().getScheduler().cancelTask(this.id);
    }

    class Task
    implements Runnable {
        Task() {
        }

        @Override
        public void run() {
            if (LiveGuiTask.this.main.getPlayerCount() == 0) {
                return;
            }
            for (Menu menu : LiveGuiTask.this.main.getMenuHandler().getOpenedMenus().values()) {
                if (!menu.getClass().equals(CubeletsMenu.class)) continue;
                List list = (List)menu.getAttribute(Menu.AttrType.CUBELET_DISPLAYED_LIST_ATTR);
                List list2 = (List)menu.getAttribute(Menu.AttrType.CUBELET_DISPLAYED_ITEMS_ATTR);
                if (list == null || list2 == null || list.size() == 0) continue;
                ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
                for (int i = 0; i < list.size(); ++i) {
                    Cubelet cubelet = (Cubelet)list.get(i);
                    if (i >= list2.size()) continue;
                    ItemStack itemStack = (ItemStack)list2.get(i);
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    if (cubelet.getExpire() > System.currentTimeMillis()) {
                        for (String string : cubelet.getCubeletType().getLoreAvailable()) {
                            arrayList2.add(Utils.translate(string.replaceAll("%received%", TimeUtils.millisToLongDHMS(System.currentTimeMillis() - cubelet.getReceived()))).replaceAll("%expires%", TimeUtils.millisToLongDHMS(cubelet.getExpire() - System.currentTimeMillis())));
                        }
                    } else {
                        for (String string : cubelet.getCubeletType().getLoreExpired()) {
                            arrayList2.add(Utils.translate(string.replaceAll("%received%", TimeUtils.millisToLongDHMS(System.currentTimeMillis() - cubelet.getReceived()))));
                        }
                    }
                    arrayList.add(new ItemBuilder(itemStack).setLore(arrayList2).toItemStack());
                }
                Bukkit.getScheduler().runTask((Plugin)LiveGuiTask.this.main, () -> {
                    Player player = menu.getOwner();
                    if (player == null) {
                        return;
                    }
                    if (!LiveGuiTask.this.main.getMenuHandler().hasOpenedMenu(player, CubeletsMenu.class)) {
                        return;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        player.getOpenInventory().getTopInventory().setItem(i, (ItemStack)arrayList.get(i));
                    }
                });
            }
        }
    }
}

