/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils.ParticlesAPI;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.davidml16.acubelets.utils.ParticlesAPI.PackageType;
import me.davidml16.acubelets.utils.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public enum Particles {
    EXPLOSION_NORMAL("explode", 0, -1, ParticleProperty.DIRECTIONAL),
    EXPLOSION_LARGE("largeexplode", 1, -1, new ParticleProperty[0]),
    EXPLOSION_HUGE("hugeexplosion", 2, -1, new ParticleProperty[0]),
    FIREWORKS_SPARK("fireworksSpark", 3, -1, ParticleProperty.DIRECTIONAL),
    WATER_BUBBLE("bubble", 4, -1, ParticleProperty.DIRECTIONAL, ParticleProperty.REQUIRES_WATER),
    WATER_SPLASH("splash", 5, -1, ParticleProperty.DIRECTIONAL),
    WATER_WAKE("wake", 6, 7, ParticleProperty.DIRECTIONAL),
    SUSPENDED("suspended", 7, -1, ParticleProperty.REQUIRES_WATER),
    SUSPENDED_DEPTH("depthSuspend", 8, -1, ParticleProperty.DIRECTIONAL),
    CRIT("crit", 9, -1, ParticleProperty.DIRECTIONAL),
    CRIT_MAGIC("magicCrit", 10, -1, ParticleProperty.DIRECTIONAL),
    SMOKE_NORMAL("smoke", 11, -1, ParticleProperty.DIRECTIONAL),
    SMOKE_LARGE("largesmoke", 12, -1, ParticleProperty.DIRECTIONAL),
    SPELL("spell", 13, -1, new ParticleProperty[0]),
    SPELL_INSTANT("instantSpell", 14, -1, new ParticleProperty[0]),
    SPELL_MOB("mobSpell", 15, -1, ParticleProperty.COLORABLE),
    SPELL_MOB_AMBIENT("mobSpellAmbient", 16, -1, ParticleProperty.COLORABLE),
    SPELL_WITCH("witchMagic", 17, -1, new ParticleProperty[0]),
    DRIP_WATER("dripWater", 18, -1, new ParticleProperty[0]),
    DRIP_LAVA("dripLava", 19, -1, new ParticleProperty[0]),
    VILLAGER_ANGRY("angryVillager", 20, -1, new ParticleProperty[0]),
    VILLAGER_HAPPY("happyVillager", 21, -1, ParticleProperty.DIRECTIONAL),
    TOWN_AURA("townaura", 22, -1, ParticleProperty.DIRECTIONAL),
    NOTE("note", 23, -1, ParticleProperty.COLORABLE),
    PORTAL("portal", 24, -1, ParticleProperty.DIRECTIONAL),
    ENCHANTMENT_TABLE("enchantmenttable", 25, -1, ParticleProperty.DIRECTIONAL),
    FLAME("flame", 26, -1, ParticleProperty.DIRECTIONAL),
    LAVA("lava", 27, -1, new ParticleProperty[0]),
    CLOUD("cloud", 29, -1, ParticleProperty.DIRECTIONAL),
    REDSTONE("reddust", 30, -1, ParticleProperty.COLORABLE),
    SNOWBALL("snowballpoof", 31, -1, new ParticleProperty[0]),
    SNOW_SHOVEL("snowshovel", 32, -1, ParticleProperty.DIRECTIONAL),
    SLIME("slime", 33, -1, new ParticleProperty[0]),
    HEART("heart", 34, -1, new ParticleProperty[0]),
    BARRIER("barrier", 35, 8, new ParticleProperty[0]),
    ITEM_CRACK("iconcrack", 36, -1, ParticleProperty.DIRECTIONAL, ParticleProperty.REQUIRES_DATA),
    BLOCK_CRACK("blockcrack", 37, -1, ParticleProperty.REQUIRES_DATA),
    BLOCK_DUST("blockdust", 38, 7, ParticleProperty.DIRECTIONAL, ParticleProperty.REQUIRES_DATA),
    WATER_DROP("droplet", 39, 8, new ParticleProperty[0]),
    MOB_APPEARANCE("mobappearance", 41, 8, new ParticleProperty[0]);

    private static final Map<String, Particles> NAME_MAP;
    private static final Map<Integer, Particles> ID_MAP;
    private final String name;
    private final int id;
    private final int requiredVersion;
    private final List<ParticleProperty> properties;

    private Particles(String string2, int n2, int n3, ParticleProperty ... particlePropertyArray) {
        this.name = string2;
        this.id = n2;
        this.requiredVersion = n3;
        this.properties = Arrays.asList(particlePropertyArray);
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getRequiredVersion() {
        return this.requiredVersion;
    }

    public boolean hasProperty(ParticleProperty particleProperty) {
        return this.properties.contains((Object)particleProperty);
    }

    public boolean isSupported() {
        return this.requiredVersion == -1 || ParticlePacket.getVersion() >= this.requiredVersion;
    }

    public static Particles fromName(String string) {
        for (Map.Entry<String, Particles> entry : NAME_MAP.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Particles fromId(int n) {
        for (Map.Entry<Integer, Particles> entry : ID_MAP.entrySet()) {
            if (entry.getKey() != n) continue;
            return entry.getValue();
        }
        return null;
    }

    private static boolean isLongDistance(Location location, List<Player> list) {
        String string = location.getWorld().getName();
        for (Player player : list) {
            Location location2 = player.getLocation();
            if (!string.equals(location2.getWorld().getName()) || location2.distanceSquared(location) < 65536.0) continue;
            return true;
        }
        return false;
    }

    private static boolean isDataCorrect(Particles particles, ParticleData particleData) {
        return (particles == BLOCK_CRACK || particles == BLOCK_DUST) && particleData instanceof BlockData || particles == ITEM_CRACK && particleData instanceof ItemData;
    }

    private static boolean isColorCorrect(Particles particles, ParticleColor particleColor) {
        return (particles == SPELL_MOB || particles == SPELL_MOB_AMBIENT || particles == REDSTONE) && particleColor instanceof OrdinaryColor || particles == NOTE && particleColor instanceof NoteColor;
    }

    public void display(float f, float f2, float f3, float f4, int n, Location location, double d) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_WATER)) {
            throw new IllegalArgumentException("There is no water at the center location");
        }
        new ParticlePacket(this, f, f2, f3, f4, n, d > 256.0, null).sendTo(location, d);
    }

    public void display(float f, float f2, float f3, float f4, int n, Location location, List<Player> list) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_WATER)) {
            throw new IllegalArgumentException("There is no water at the center location");
        }
        new ParticlePacket(this, f, f2, f3, f4, n, Particles.isLongDistance(location, list), null).sendTo(location, list);
    }

    public void display(float f, float f2, float f3, float f4, int n, Location location, Player ... playerArray) {
        this.display(f, f2, f3, f4, n, location, Arrays.asList(playerArray));
    }

    public void display(Vector vector, float f, Location location, double d) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        if (!this.hasProperty(ParticleProperty.DIRECTIONAL)) {
            throw new IllegalArgumentException("This particle effect is not directional");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_WATER)) {
            throw new IllegalArgumentException("There is no water at the center location");
        }
        new ParticlePacket(this, vector, f, d > 256.0, null).sendTo(location, d);
    }

    public void display(Vector vector, float f, Location location, List<Player> list) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        if (!this.hasProperty(ParticleProperty.DIRECTIONAL)) {
            throw new IllegalArgumentException("This particle effect is not directional");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_WATER)) {
            throw new IllegalArgumentException("There is no water at the center location");
        }
        new ParticlePacket(this, vector, f, Particles.isLongDistance(location, list), null).sendTo(location, list);
    }

    public void display(Vector vector, float f, Location location, Player ... playerArray) {
        this.display(vector, f, location, Arrays.asList(playerArray));
    }

    public void display(ParticleColor particleColor, Location location, double d) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.COLORABLE)) {
            throw new ParticleColorException("This particle effect is not colorable");
        }
        if (!Particles.isColorCorrect(this, particleColor)) {
            throw new ParticleColorException("The particle color type is incorrect");
        }
        new ParticlePacket(this, particleColor, d > 256.0).sendTo(location, d);
    }

    public void display(ParticleColor particleColor, Location location, List<Player> list) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.COLORABLE)) {
            throw new ParticleColorException("This particle effect is not colorable");
        }
        if (!Particles.isColorCorrect(this, particleColor)) {
            throw new ParticleColorException("The particle color type is incorrect");
        }
        new ParticlePacket(this, particleColor, Particles.isLongDistance(location, list)).sendTo(location, list);
    }

    public void display(ParticleColor particleColor, Location location, Player ... playerArray) {
        this.display(particleColor, location, Arrays.asList(playerArray));
    }

    public void display(ParticleData particleData, float f, float f2, float f3, float f4, int n, Location location, double d) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect does not require additional data");
        }
        if (!Particles.isDataCorrect(this, particleData)) {
            throw new ParticleDataException("The particle data type is incorrect");
        }
        new ParticlePacket(this, f, f2, f3, f4, n, d > 256.0, particleData).sendTo(location, d);
    }

    public void display(ParticleData particleData, float f, float f2, float f3, float f4, int n, Location location, List<Player> list) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect does not require additional data");
        }
        if (!Particles.isDataCorrect(this, particleData)) {
            throw new ParticleDataException("The particle data type is incorrect");
        }
        new ParticlePacket(this, f, f2, f3, f4, n, Particles.isLongDistance(location, list), particleData).sendTo(location, list);
    }

    public void display(ParticleData particleData, float f, float f2, float f3, float f4, int n, Location location, Player ... playerArray) {
        this.display(particleData, f, f2, f3, f4, n, location, Arrays.asList(playerArray));
    }

    public void display(ParticleData particleData, Vector vector, float f, Location location, double d) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect does not require additional data");
        }
        if (!Particles.isDataCorrect(this, particleData)) {
            throw new ParticleDataException("The particle data type is incorrect");
        }
        new ParticlePacket(this, vector, f, d > 256.0, particleData).sendTo(location, d);
    }

    public void display(ParticleData particleData, Vector vector, float f, Location location, List<Player> list) {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect does not require additional data");
        }
        if (!Particles.isDataCorrect(this, particleData)) {
            throw new ParticleDataException("The particle data type is incorrect");
        }
        new ParticlePacket(this, vector, f, Particles.isLongDistance(location, list), particleData).sendTo(location, list);
    }

    public void display(ParticleData particleData, Vector vector, float f, Location location, Player ... playerArray) {
        this.display(particleData, vector, f, location, Arrays.asList(playerArray));
    }

    static {
        NAME_MAP = new HashMap<String, Particles>();
        ID_MAP = new HashMap<Integer, Particles>();
        for (Particles particles : Particles.values()) {
            NAME_MAP.put(particles.name, particles);
            ID_MAP.put(particles.id, particles);
        }
    }

    public static final class ParticlePacket {
        private static int version;
        private static Class<?> enumParticle;
        private static Constructor<?> packetConstructor;
        private static Method getHandle;
        private static Field playerConnection;
        private static Method sendPacket;
        private static boolean initialized;
        private static boolean useSendParticle;
        private final Particles effect;
        private float offsetX;
        private final float offsetY;
        private final float offsetZ;
        private final float speed;
        private final int amount;
        private final boolean longDistance;
        private final ParticleData data;
        private Object packet;

        public ParticlePacket(Particles particles, float f, float f2, float f3, float f4, int n, boolean bl, ParticleData particleData) {
            ParticlePacket.initialize();
            if (f4 < 0.0f) {
                throw new IllegalArgumentException("The speed is lower than 0");
            }
            if (n < 0) {
                throw new IllegalArgumentException("The amount is lower than 0");
            }
            this.effect = particles;
            this.offsetX = f;
            this.offsetY = f2;
            this.offsetZ = f3;
            this.speed = f4;
            this.amount = n;
            this.longDistance = bl;
            this.data = particleData;
        }

        public ParticlePacket(Particles particles, Vector vector, float f, boolean bl, ParticleData particleData) {
            this(particles, (float)vector.getX(), (float)vector.getY(), (float)vector.getZ(), f, 0, bl, particleData);
        }

        public ParticlePacket(Particles particles, ParticleColor particleColor, boolean bl) {
            this(particles, particleColor.getValueX(), particleColor.getValueY(), particleColor.getValueZ(), 1.0f, 0, bl, null);
            if (particles == REDSTONE && particleColor instanceof OrdinaryColor && ((OrdinaryColor)particleColor).getRed() == 0) {
                this.offsetX = Float.MIN_NORMAL;
            }
        }

        public static void initialize() {
            if (initialized) {
                return;
            }
            try {
                version = Integer.parseInt(PackageType.getServerVersion().split("_")[1]);
                if (version <= 7 || version >= 13) {
                    initialized = true;
                    useSendParticle = true;
                    return;
                }
                enumParticle = PackageType.MINECRAFT_SERVER.getClass("EnumParticle");
                useSendParticle = false;
                Class<?> clazz = PackageType.MINECRAFT_SERVER.getClass(version < 7 ? "Packet63WorldParticles" : "PacketPlayOutWorldParticles");
                packetConstructor = ReflectionUtils.getConstructor(clazz, new Class[0]);
                getHandle = ReflectionUtils.getMethod("CraftPlayer", PackageType.CRAFTBUKKIT_ENTITY, "getHandle", new Class[0]);
                playerConnection = ReflectionUtils.getField("EntityPlayer", PackageType.MINECRAFT_SERVER, false, "playerConnection");
                sendPacket = ReflectionUtils.getMethod(playerConnection.getType(), "sendPacket", PackageType.MINECRAFT_SERVER.getClass("Packet"));
            }
            catch (Exception exception) {
                throw new VersionIncompatibleException("Your current bukkit version seems to be incompatible with this library", exception);
            }
            initialized = true;
        }

        public static int getVersion() {
            if (!initialized) {
                ParticlePacket.initialize();
            }
            return version;
        }

        public static boolean isInitialized() {
            return initialized;
        }

        private void initializePacket(Location location) {
            if (this.packet != null) {
                return;
            }
            if (!useSendParticle) {
                try {
                    this.packet = packetConstructor.newInstance(new Object[0]);
                    if (version < 8) {
                        String string = this.effect.getName();
                        if (this.data != null) {
                            string = string + this.data.getPacketDataString();
                        }
                        ReflectionUtils.setValue(this.packet, true, "a", string);
                    } else {
                        ReflectionUtils.setValue(this.packet, true, "a", enumParticle.getEnumConstants()[this.effect.getId()]);
                        ReflectionUtils.setValue(this.packet, true, "j", this.longDistance);
                        if (this.data != null) {
                            int[] nArray;
                            int[] nArray2 = this.data.getPacketData();
                            if (this.effect == ITEM_CRACK) {
                                nArray = nArray2;
                            } else {
                                int[] nArray3 = new int[1];
                                nArray = nArray3;
                                nArray3[0] = nArray2[0] | nArray2[1] << 12;
                            }
                            ReflectionUtils.setValue(this.packet, true, "k", nArray);
                        }
                    }
                    ReflectionUtils.setValue(this.packet, true, "b", Float.valueOf((float)location.getX()));
                    ReflectionUtils.setValue(this.packet, true, "c", Float.valueOf((float)location.getY()));
                    ReflectionUtils.setValue(this.packet, true, "d", Float.valueOf((float)location.getZ()));
                    ReflectionUtils.setValue(this.packet, true, "e", Float.valueOf(this.offsetX));
                    ReflectionUtils.setValue(this.packet, true, "f", Float.valueOf(this.offsetY));
                    ReflectionUtils.setValue(this.packet, true, "g", Float.valueOf(this.offsetZ));
                    ReflectionUtils.setValue(this.packet, true, "h", Float.valueOf(this.speed));
                    ReflectionUtils.setValue(this.packet, true, "i", this.amount);
                }
                catch (Exception exception) {
                    throw new PacketInstantiationException("Packet instantiation failed", exception);
                }
            } else if (this.effect == REDSTONE) {
                int n = (int)(this.offsetX * 255.0f);
                int n2 = (int)(this.offsetY * 255.0f);
                int n3 = (int)(this.offsetZ * 255.0f);
                if (n == 0 && n2 == 0 && n3 == 0) {
                    n = 255;
                }
                location.getWorld().spawnParticle(Particle.valueOf((String)this.effect.toString()), location, 0, (Object)new Particle.DustOptions(Color.fromRGB((int)n, (int)n2, (int)n3), 1.0f));
            } else if (this.effect == SPELL_MOB || this.effect == SPELL_MOB_AMBIENT) {
                location.getWorld().spawnParticle(Particle.valueOf((String)this.effect.toString()), location, this.amount, (double)this.offsetX, (double)this.offsetY, (double)this.offsetZ, 1.0);
            } else if (this.effect == NOTE) {
                location.getWorld().spawnParticle(Particle.valueOf((String)this.effect.toString()), location, this.amount, (double)this.offsetX, 0.0, 0.0, 1.0);
            } else if (this.effect == ITEM_CRACK) {
                location.getWorld().spawnParticle(Particle.valueOf((String)this.effect.toString()), location, this.amount, (double)this.offsetX, (double)this.offsetY, (double)this.offsetZ, (Object)new ItemStack(this.data.getMaterial()));
            } else if (this.effect == BLOCK_CRACK) {
                location.getWorld().spawnParticle(Particle.valueOf((String)this.effect.toString()), location, this.amount, (double)this.offsetX, (double)this.offsetY, (double)this.offsetZ, (Object)this.data.getMaterial().createBlockData());
            } else {
                location.getWorld().spawnParticle(Particle.valueOf((String)this.effect.toString()), location.getX(), location.getY(), location.getZ(), this.amount, (double)this.offsetX, (double)this.offsetY, (double)this.offsetZ, (double)this.speed);
            }
        }

        public void sendTo(Location location, Player player) {
            this.initializePacket(location);
            if (useSendParticle) {
                return;
            }
            try {
                sendPacket.invoke(playerConnection.get(getHandle.invoke((Object)player, new Object[0])), this.packet);
            }
            catch (Exception exception) {
                throw new PacketSendingException("Failed to send the packet to player '" + player.getName() + "'", exception);
            }
        }

        public void sendTo(Location location, List<Player> list) {
            if (useSendParticle) {
                this.initializePacket(location);
                return;
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("The player list is empty");
            }
            for (Player player : list) {
                this.sendTo(location, player);
            }
        }

        public void sendTo(Location location, double d) {
            if (useSendParticle) {
                this.initializePacket(location);
                return;
            }
            if (d < 1.0) {
                throw new IllegalArgumentException("The range is lower than 1");
            }
            String string = location.getWorld().getName();
            double d2 = d * d;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getWorld().getName().equals(string) || player.getLocation().distanceSquared(location) > d2) continue;
                this.sendTo(location, player);
            }
        }

        private static final class PacketSendingException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public PacketSendingException(String string, Throwable throwable) {
                super(string, throwable);
            }
        }

        private static final class PacketInstantiationException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public PacketInstantiationException(String string, Throwable throwable) {
                super(string, throwable);
            }
        }

        private static final class VersionIncompatibleException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public VersionIncompatibleException(String string, Throwable throwable) {
                super(string, throwable);
            }
        }
    }

    private static final class ParticleVersionException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public ParticleVersionException(String string) {
            super(string);
        }
    }

    private static final class ParticleColorException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public ParticleColorException(String string) {
            super(string);
        }
    }

    private static final class ParticleDataException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public ParticleDataException(String string) {
            super(string);
        }
    }

    public static final class NoteColor
    extends ParticleColor {
        private final int note;

        public NoteColor(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("The note value is lower than 0");
            }
            if (n > 24) {
                throw new IllegalArgumentException("The note value is higher than 24");
            }
            this.note = n;
        }

        @Override
        public float getValueX() {
            return (float)this.note / 24.0f;
        }

        @Override
        public float getValueY() {
            return 0.0f;
        }

        @Override
        public float getValueZ() {
            return 0.0f;
        }
    }

    public static final class OrdinaryColor
    extends ParticleColor {
        private final int red;
        private final int green;
        private final int blue;

        public OrdinaryColor(int n, int n2, int n3) {
            this.red = Math.min(255, n);
            this.green = Math.min(255, n2);
            this.blue = Math.min(255, n3);
        }

        public OrdinaryColor(Color color) {
            this(color.getRed(), color.getGreen(), color.getBlue());
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        @Override
        public float getValueX() {
            return (float)this.red / 255.0f;
        }

        @Override
        public float getValueY() {
            return (float)this.green / 255.0f;
        }

        @Override
        public float getValueZ() {
            return (float)this.blue / 255.0f;
        }
    }

    public static abstract class ParticleColor {
        public abstract float getValueX();

        public abstract float getValueY();

        public abstract float getValueZ();
    }

    public static final class BlockData
    extends ParticleData {
        public BlockData(Material material, byte by) {
            super(material, by);
            if (!material.isBlock()) {
                throw new IllegalArgumentException("The material is not a block");
            }
        }
    }

    public static final class ItemData
    extends ParticleData {
        public ItemData(Material material, byte by) {
            super(material, by);
        }
    }

    public static abstract class ParticleData {
        private final Material material;
        private final byte data;
        private final int[] packetData;

        public ParticleData(Material material, byte by) {
            this.material = material;
            this.data = by;
            this.packetData = new int[]{material.getId(), by};
        }

        public Material getMaterial() {
            return this.material;
        }

        public byte getData() {
            return this.data;
        }

        public int[] getPacketData() {
            return this.packetData;
        }

        public String getPacketDataString() {
            return "_" + this.packetData[0] + "_" + this.packetData[1];
        }
    }

    public static enum ParticleProperty {
        REQUIRES_WATER,
        REQUIRES_DATA,
        DIRECTIONAL,
        COLORABLE;

    }
}

