/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils.random;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import me.davidml16.acubelets.utils.CollectionUtils;
import me.davidml16.acubelets.utils.Pair;
import me.davidml16.acubelets.utils.random.MTRandom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rnd {
    public static final MTRandom rnd = new MTRandom();

    public static float get() {
        return rnd.nextFloat();
    }

    public static float get(boolean bl) {
        float f = Rnd.get();
        if (bl) {
            f *= 100.0f;
        }
        return f;
    }

    public static int get(int n) {
        return Rnd.nextInt(n);
    }

    public static int get(int n, int n2) {
        return n + (int)Math.floor(rnd.nextDouble() * (double)(n2 - n + 1));
    }

    public static double getDouble(double d) {
        return Rnd.getDouble(0.0, d);
    }

    public static double getDouble(double d, double d2) {
        return d + (d2 - d) * rnd.nextDouble();
    }

    @NotNull
    public static <E> E get(@NotNull E[] EArray) {
        return EArray[Rnd.get(EArray.length)];
    }

    public static int get(int[] nArray) {
        return nArray[Rnd.get(nArray.length)];
    }

    @NotNull
    public static <E> E get(@NotNull List<E> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException("Empty list provided!");
        }
        return list.get(Rnd.get(list.size()));
    }

    @NotNull
    public static <E> E get(@NotNull Set<E> set) {
        return Rnd.get(new ArrayList<E>(set));
    }

    @Deprecated
    @Nullable
    public static <T> T get(@NotNull @NotNull Map<@NotNull T, Double> map) {
        List<T> list = Rnd.get(map, 1);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @NotNull
    public static <T> T getByWeight(@NotNull Map<T, Double> map) {
        int n;
        ArrayList<Pair<T, Double>> arrayList = new ArrayList<Pair<T, Double>>();
        for (Map.Entry<T, Double> entry : CollectionUtils.sortAscent(map).entrySet()) {
            if (!(entry.getValue() > 0.0)) continue;
            Pair<T, Double> pair = Pair.of(entry.getKey(), entry.getValue());
            arrayList.add(pair);
        }
        double d = arrayList.stream().mapToDouble(Pair::getSecond).sum();
        double d2 = Rnd.nextDouble() * d;
        for (n = 0; n < arrayList.size() - 1 && !((d2 -= ((Double)((Pair)arrayList.get(n)).getSecond()).doubleValue()) <= 0.0); ++n) {
        }
        return (T)((Pair)arrayList.get(n)).getFirst();
    }

    @Deprecated
    @NotNull
    public static <T> List<T> get(@NotNull @NotNull Map<@NotNull T, Double> map, int n) {
        map.values().removeIf(d -> d <= 0.0);
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        double d2 = map.values().stream().mapToDouble(d -> d).sum();
        block0: for (int i = 0; i < n; ++i) {
            double d3 = Rnd.getDouble(0.0, d2);
            double d4 = 0.0;
            for (Map.Entry<T, Double> entry : map.entrySet()) {
                if (!((d4 += entry.getValue().doubleValue()) >= d3)) continue;
                arrayList.add(entry.getKey());
                continue block0;
            }
        }
        return arrayList;
    }

    public static boolean chance(int n) {
        return n >= 1 && (n > 99 || Rnd.nextInt(99) + 1 <= n);
    }

    public static boolean chance(double d) {
        return Rnd.nextDouble() <= d / 100.0;
    }

    public static int nextInt(int n) {
        return (int)Math.floor(rnd.nextDouble() * (double)n);
    }

    public static int nextInt() {
        return rnd.nextInt();
    }

    public static double nextDouble() {
        return rnd.nextDouble();
    }

    public static double nextGaussian() {
        return rnd.nextGaussian();
    }

    public static boolean nextBoolean() {
        return rnd.nextBoolean();
    }
}

