/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Node;

public class Range {
    private final Position start;
    private final Position end;
    private static final String RangeKey = Attributes.internalKey("jsoup.sourceRange");
    private static final String EndRangeKey = Attributes.internalKey("jsoup.endSourceRange");
    private static final Position UntrackedPos = new Position(-1, -1, -1);
    private static final Range Untracked = new Range(UntrackedPos, UntrackedPos);

    public Range(Position position, Position position2) {
        this.start = position;
        this.end = position2;
    }

    public Position start() {
        return this.start;
    }

    public Position end() {
        return this.end;
    }

    public boolean isTracked() {
        return this != Untracked;
    }

    static Range of(Node node, boolean bl) {
        String string;
        String string2 = string = bl ? RangeKey : EndRangeKey;
        if (!node.hasAttr(string)) {
            return Untracked;
        }
        return (Range)Validate.ensureNotNull(node.attributes().getUserData(string));
    }

    public void track(Node node, boolean bl) {
        node.attributes().putUserData(bl ? RangeKey : EndRangeKey, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Range range = (Range)object;
        if (!this.start.equals(range.start)) {
            return false;
        }
        return this.end.equals(range.end);
    }

    public int hashCode() {
        int n = this.start.hashCode();
        n = 31 * n + this.end.hashCode();
        return n;
    }

    public String toString() {
        return this.start + "-" + this.end;
    }

    public static class Position {
        private final int pos;
        private final int lineNumber;
        private final int columnNumber;

        public Position(int n, int n2, int n3) {
            this.pos = n;
            this.lineNumber = n2;
            this.columnNumber = n3;
        }

        public int pos() {
            return this.pos;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public int columnNumber() {
            return this.columnNumber;
        }

        public boolean isTracked() {
            return this != UntrackedPos;
        }

        public String toString() {
            return this.lineNumber + "," + this.columnNumber + ":" + this.pos;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Position position = (Position)object;
            if (this.pos != position.pos) {
                return false;
            }
            if (this.lineNumber != position.lineNumber) {
                return false;
            }
            return this.columnNumber == position.columnNumber;
        }

        public int hashCode() {
            int n = this.pos;
            n = 31 * n + this.lineNumber;
            n = 31 * n + this.columnNumber;
            return n;
        }
    }
}

