/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.Range;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    protected Parser parser;
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseSettings settings;
    protected Map<String, Tag> seenTags;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();
    private boolean trackSourceRange;

    TreeBuilder() {
    }

    abstract ParseSettings defaultSettings();

    @ParametersAreNonnullByDefault
    protected void initialiseParse(Reader reader, String string, Parser parser) {
        Validate.notNullParam(reader, "input");
        Validate.notNullParam(string, "baseUri");
        Validate.notNull(parser);
        this.doc = new Document(string);
        this.doc.parser(parser);
        this.parser = parser;
        this.settings = parser.settings();
        this.reader = new CharacterReader(reader);
        this.trackSourceRange = parser.isTrackPosition();
        this.reader.trackNewlines(parser.isTrackErrors() || this.trackSourceRange);
        this.currentToken = null;
        this.tokeniser = new Tokeniser(this.reader, parser.getErrors());
        this.stack = new ArrayList(32);
        this.seenTags = new HashMap<String, Tag>();
        this.baseUri = string;
    }

    @ParametersAreNonnullByDefault
    Document parse(Reader reader, String string, Parser parser) {
        this.initialiseParse(reader, string, parser);
        this.runParser();
        this.reader.close();
        this.reader = null;
        this.tokeniser = null;
        this.stack = null;
        this.seenTags = null;
        return this.doc;
    }

    abstract TreeBuilder newInstance();

    abstract List<Node> parseFragment(String var1, Element var2, String var3, Parser var4);

    protected void runParser() {
        Token token;
        Tokeniser tokeniser = this.tokeniser;
        Token.TokenType tokenType = Token.TokenType.EOF;
        do {
            token = tokeniser.read();
            this.process(token);
            token.reset();
        } while (token.type != tokenType);
    }

    protected abstract boolean process(Token var1);

    protected boolean processStartTag(String string) {
        Token.StartTag startTag = this.start;
        if (this.currentToken == startTag) {
            return this.process(new Token.StartTag().name(string));
        }
        return this.process(startTag.reset().name(string));
    }

    public boolean processStartTag(String string, Attributes attributes) {
        Token.StartTag startTag = this.start;
        if (this.currentToken == startTag) {
            return this.process(new Token.StartTag().nameAttr(string, attributes));
        }
        startTag.reset();
        startTag.nameAttr(string, attributes);
        return this.process(startTag);
    }

    protected boolean processEndTag(String string) {
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(string));
        }
        return this.process(this.end.reset().name(string));
    }

    protected Element currentElement() {
        int n = this.stack.size();
        return n > 0 ? this.stack.get(n - 1) : this.doc;
    }

    protected boolean currentElementIs(String string) {
        if (this.stack.size() == 0) {
            return false;
        }
        Element element = this.currentElement();
        return element != null && element.normalName().equals(string);
    }

    protected void error(String string) {
        this.error(string, null);
    }

    protected void error(String string, Object ... objectArray) {
        ParseErrorList parseErrorList = this.parser.getErrors();
        if (parseErrorList.canAddError()) {
            parseErrorList.add(new ParseError(this.reader, string, objectArray));
        }
    }

    protected boolean isContentForTagData(String string) {
        return false;
    }

    protected Tag tagFor(String string, ParseSettings parseSettings) {
        Tag tag = this.seenTags.get(string);
        if (tag == null) {
            tag = Tag.valueOf(string, parseSettings);
            this.seenTags.put(string, tag);
        }
        return tag;
    }

    protected void onNodeInserted(Node node, @Nullable Token token) {
        this.trackNodePosition(node, token, true);
    }

    protected void onNodeClosed(Node node, Token token) {
        this.trackNodePosition(node, token, false);
    }

    private void trackNodePosition(Node node, @Nullable Token token, boolean bl) {
        if (this.trackSourceRange && token != null) {
            int n = token.startPos();
            if (n == -1) {
                return;
            }
            Range.Position position = new Range.Position(n, this.reader.lineNumber(n), this.reader.columnNumber(n));
            int n2 = token.endPos();
            Range.Position position2 = new Range.Position(n2, this.reader.lineNumber(n2), this.reader.columnNumber(n2));
            Range range = new Range(position, position2);
            range.track(node, bl);
        }
    }
}

