/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.actions.bloodmoon;

import me.mrgeneralq.bloodmoon.interfaces.actions.IBloodmoonAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class ShieldAction
implements IBloodmoonAction {
    private final IBloodmoonService bloodmoonService;
    private final IMobService mobService;
    private String[] args;

    public ShieldAction(IBloodmoonService iBloodmoonService, IMobService iMobService) {
        this.bloodmoonService = iBloodmoonService;
        this.mobService = iMobService;
    }

    @Override
    public void executeAction(Object object) {
        if (!(object instanceof Object[])) {
            return;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length < 3) {
            return;
        }
        try {
            LivingEntity livingEntity = (LivingEntity)objectArray[0];
            EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)objectArray[1];
            int n = Integer.parseInt((String)objectArray[2]);
            livingEntity.setMetadata("shieldDuration", (MetadataValue)new FixedMetadataValue(this.mobService.getPlugin(), (Object)n));
            entityDamageByEntityEvent.setCancelled(true);
            Statics.createShieldEffect(livingEntity.getLocation());
            this.bloodmoonService.addActiveShield(livingEntity.getUniqueId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setArgs(String[] stringArray) {
        this.args = stringArray;
    }

    @Override
    public String getName() {
        return Statics.SHIELD_ACTION;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isValidArgs(String[] stringArray) {
        try {
            Integer.parseInt(stringArray[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getArgsUsage() {
        return String.format("%s <duration>", Statics.SHIELD_ACTION);
    }
}

