/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.actions.sign;

import me.mrgeneralq.bloodmoon.enums.DataModification;
import me.mrgeneralq.bloodmoon.interfaces.actions.ISignAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Bootstrapper;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class NextSignAction
implements ISignAction {
    private final Bootstrapper bootstrapper = Bootstrapper.getBootstrapper();
    private final IBloodmoonService bloodmoonService = this.bootstrapper.getBloodmoonService();
    private final IMessageService messageService = this.bootstrapper.getMessageService();
    private final IConfigService configService = this.bootstrapper.getConfigService();
    private final IBloodmoonScheduleService scheduleService = this.bootstrapper.getBloodmoonScheduleService();

    @Override
    public void executeAction(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        World world = player.getWorld();
        if (!this.configService.worldIsEnabled(world)) {
            player.sendMessage(this.messageService.getMessage(Message.worldNotEnabled, true));
            return;
        }
        if (this.bloodmoonService.bloodmoonIsRunning(world)) {
            player.sendMessage(this.messageService.getMessage(Message.bloodmoonAlreadyRunning, true));
            return;
        }
        if (this.scheduleService.isScheduled(world)) {
            BloodmoonSchedule bloodmoonSchedule = this.scheduleService.getSchedule(world);
            if (bloodmoonSchedule.isToday()) {
                player.sendMessage(this.messageService.getMessageHelper(Message.alreadyScheduled).useConfigMessage().usePrefix().setSchedule(bloodmoonSchedule).getMessage());
                return;
            }
            bloodmoonSchedule.setDaysLeft(this.bloodmoonService.isNight(world) ? 0 : -1);
            player.sendMessage(this.messageService.getMessageHelper(Message.scheduled).useConfigMessage().usePrefix().setSchedule(bloodmoonSchedule).getMessage());
            return;
        }
        BloodmoonSchedule bloodmoonSchedule = new BloodmoonSchedule(world, 0, 100.0);
        this.scheduleService.addSchedule(bloodmoonSchedule, DataModification.MEMORY);
        player.sendMessage(this.messageService.getMessageHelper(Message.scheduled).useConfigMessage().usePrefix().setSchedule(bloodmoonSchedule).getMessage());
    }

    @Override
    public boolean isValidCreation(SignChangeEvent signChangeEvent) {
        return true;
    }
}

