/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.item;

import me.mrgeneralq.bloodmoon.defaults.DefaultItem;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GetItem
implements ISubCommand {
    private final IItemService itemService;
    private final IMessageService messageService;
    private final IConfigService configService;

    public GetItem(IItemService iItemService, IMessageService iMessageService, IConfigService iConfigService) {
        this.itemService = iItemService;
        this.messageService = iMessageService;
        this.configService = iConfigService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ItemStack itemStack;
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("item").getMessage());
            return true;
        }
        DefaultItem defaultItem = this.itemService.getItem(stringArray[0]);
        if (defaultItem == null && !stringArray[0].equalsIgnoreCase(Statics.PATH_FINDER_NAME)) {
            commandSender.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("item").getMessage());
            return true;
        }
        Material material = Material.matchMaterial((String)this.configService.getPathMaterial());
        if (defaultItem == null && material == null) {
            return true;
        }
        ItemStack itemStack2 = itemStack = defaultItem != null ? defaultItem.getItem() : new ItemStack(material);
        if (defaultItem == null) {
            Statics.setPathFinderMeta(itemStack);
        }
        if (stringArray.length >= 2) {
            int n;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                player.sendMessage(this.messageService.getMessageHelper(Message.typeNotValid).useConfigMessage().usePrefix().setType("count").getMessage());
                return true;
            }
            itemStack.setAmount(n);
        }
        player.getInventory().addItem(new ItemStack[]{itemStack});
        player.sendMessage(this.messageService.getMessageHelper(Message.itemReceived).useConfigMessage().usePrefix().setPlayer("You").setAmount(String.valueOf(itemStack.getAmount())).setType(defaultItem != null ? defaultItem.getItemId() : "Pathfinder").getMessage());
        return true;
    }
}

