/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.item;

import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.ItemStackSerializer;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PrintItem
implements ISubCommand {
    private final IItemService itemService;
    private final IMessageService messageService;

    public PrintItem(IItemService iItemService, IMessageService iMessageService) {
        this.itemService = iItemService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ItemStack itemStack;
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        try {
            itemStack = player.getInventory().getItemInMainHand();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            itemStack = player.getItemInHand();
        }
        if (itemStack.getType() == Material.AIR) {
            player.sendMessage(this.messageService.getMessage(Message.holdItem, true));
            return true;
        }
        player.sendMessage(this.messageService.getMessage(Message.useData, true));
        player.sendMessage(Message.getMessage(ItemStackSerializer.serialize(itemStack)));
        return true;
    }
}

