/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.item;

import me.mrgeneralq.bloodmoon.defaults.DefaultItem;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RemoveItem
implements ISubCommand {
    private final IItemService itemService;
    private final IMessageService messageService;

    public RemoveItem(IItemService iItemService, IMessageService iMessageService) {
        this.itemService = iItemService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("item").getMessage());
            return true;
        }
        DefaultItem defaultItem = this.itemService.getItem(stringArray[0]);
        if (defaultItem == null) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("item").getMessage());
            return true;
        }
        this.itemService.removeItem(defaultItem.getItemId());
        player.sendMessage(this.messageService.getMessageHelper(Message.typeRemoved).useConfigMessage().usePrefix().setType(stringArray[0]).getMessage());
        return true;
    }
}

