/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.lifecycle;

import java.util.List;
import me.mrgeneralq.bloodmoon.defaults.DefaultLifecycle;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.ILifeCycleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListCycleAction
implements ISubCommand {
    private final ILifeCycleService lifeCycleService;
    private final IMessageService messageService;

    public ListCycleAction(ILifeCycleService iLifeCycleService, IMessageService iMessageService) {
        this.lifeCycleService = iLifeCycleService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("cycle name").getMessage());
            return true;
        }
        String string2 = stringArray[0];
        DefaultLifecycle defaultLifecycle = this.lifeCycleService.getCycle(string2);
        if (defaultLifecycle == null) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("lifecycle").getMessage());
            return true;
        }
        List<String> list = defaultLifecycle.getActions();
        if (list.size() == 0) {
            player.sendMessage(this.messageService.getMessageHelper(Message.emptyTypeList).useConfigMessage().usePrefix().setType("lifecycle").setSubType("actions").getMessage());
            return true;
        }
        player.sendMessage(this.messageService.getMessageHelper(Message.typeList).useConfigMessage().usePrefix().setType("actions").getMessage());
        for (int i = 0; i < list.size(); ++i) {
            String string3 = this.messageService.getMessageHelper(Message.listItem).useConfigMessage().setPosition(String.valueOf(i)).setArg(list.get(i)).getMessage();
            player.sendMessage(Message.getMessage(string3));
        }
        return true;
    }
}

