/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.mob;

import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.commandproperties.IMobCommandProperty;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetPropertyMob
implements ISubCommand {
    private final IMobService mobService;
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;

    public SetPropertyMob(IMobService iMobService, IBloodmoonService iBloodmoonService, IMessageService iMessageService) {
        this.mobService = iMobService;
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("property").getMessage());
            return true;
        }
        String string2 = stringArray[0];
        IMobCommandProperty iMobCommandProperty = this.bloodmoonService.getMobCommandProperties().getOrDefault(string2, null);
        if (iMobCommandProperty == null) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotValid).useConfigMessage().usePrefix().setType("property").getMessage());
            return true;
        }
        if (stringArray.length < 2) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("mob name").getMessage());
            return true;
        }
        String string3 = stringArray[1];
        DefaultMob defaultMob = this.mobService.getMob(string3);
        if (defaultMob == null) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("mob").getMessage());
            return true;
        }
        if (!iMobCommandProperty.isValidPropertyForMobType(defaultMob.getType())) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotValid).useConfigMessage().usePrefix().setType("property").getMessage());
            return true;
        }
        if (stringArray.length < 3) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("value").getMessage());
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 2; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]).append(" ");
        }
        if (!iMobCommandProperty.isValidPropertyValue(stringBuilder.toString().trim())) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotValid).useConfigMessage().usePrefix().setType("value").getMessage());
            player.sendMessage(Message.getMessage(String.format("Use: %s", iMobCommandProperty.getPropertyUsage())));
            return true;
        }
        iMobCommandProperty.setValue(defaultMob);
        this.mobService.updateMob(defaultMob);
        player.sendMessage(this.messageService.getMessageHelper(Message.typeUpdated).useConfigMessage().usePrefix().setType(defaultMob.getMobID()).getMessage());
        return true;
    }
}

