/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.mob;

import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class SpawnBoss
implements ISubCommand {
    private final IMobService mobService;
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;

    public SpawnBoss(IMobService iMobService, IMessageService iMessageService, IBloodmoonService iBloodmoonService) {
        this.mobService = iMobService;
        this.messageService = iMessageService;
        this.bloodmoonService = iBloodmoonService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("mob name").getMessage());
            return true;
        }
        String string2 = stringArray[0];
        DefaultMob defaultMob = this.mobService.getMob(string2);
        if (defaultMob == null) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("mob").getMessage());
            return true;
        }
        if (defaultMob.getType() == null) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("entity type").getMessage());
            return true;
        }
        if (!defaultMob.isBoss()) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("boss").getMessage());
            return true;
        }
        LivingEntity livingEntity = this.mobService.spawnMob(player.getLocation(), defaultMob, true);
        if (this.bloodmoonService.bloodmoonIsRunning(livingEntity.getWorld())) {
            this.bloodmoonService.registerMob(livingEntity, livingEntity.getWorld());
        }
        player.sendMessage(this.messageService.getMessageHelper(Message.typeSpawned).useConfigMessage().usePrefix().setType(string2).getMessage());
        return true;
    }
}

