/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.schedule;

import me.mrgeneralq.bloodmoon.enums.DataModification;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ScheduleCreateCommand
implements ISubCommand {
    private IBloodmoonScheduleService bloodmoonScheduleService;
    private IMessageService messageService;
    private IConfigService configService;

    public ScheduleCreateCommand(IBloodmoonScheduleService iBloodmoonScheduleService, IMessageService iMessageService, IConfigService iConfigService) {
        this.bloodmoonScheduleService = iBloodmoonScheduleService;
        this.messageService = iMessageService;
        this.configService = iConfigService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Player player = (Player)commandSender;
        World world = player.getWorld();
        if (stringArray.length > 0) {
            if (Bukkit.getWorld((String)stringArray[0]) == null) {
                player.sendMessage(this.messageService.getMessage(Message.invalidWorld, true));
                return true;
            }
            world = Bukkit.getWorld((String)stringArray[0]);
        }
        if (!this.configService.worldIsEnabled(world)) {
            player.sendMessage(this.messageService.getMessage(Message.worldNotEnabled, true));
            return true;
        }
        if (this.bloodmoonScheduleService.scheduleExists(world)) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeExists).useConfigMessage().usePrefix().setType("schedule").getMessage());
            return true;
        }
        BloodmoonSchedule bloodmoonSchedule = new BloodmoonSchedule(world);
        this.bloodmoonScheduleService.addSchedule(bloodmoonSchedule, DataModification.ALL);
        player.sendMessage(this.messageService.getMessageHelper(Message.typeCreated).useConfigMessage().usePrefix().setType("schedule").getMessage());
        return true;
    }
}

