/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.defaults;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrgeneralq.bloodmoon.interfaces.actions.IBloodmoonAction;
import me.mrgeneralq.bloodmoon.statics.Statics;
import me.mrgeneralq.bloodmoon.statics.Tuple;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;

@SerializableAs(value="DefaultAction")
public class DefaultAction
implements ConfigurationSerializable {
    private String actionID;
    private List<String> events;
    private List<String> commands;

    public DefaultAction(Map<String, Object> map) {
        this.events = map.getOrDefault("events", new ArrayList());
        this.commands = map.getOrDefault("commands", new ArrayList());
    }

    public DefaultAction(String string) {
        this.actionID = string;
        this.events = new ArrayList<String>();
        this.commands = new ArrayList<String>();
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("events", this.events);
        hashMap.put("commands", this.commands);
        return hashMap;
    }

    public String getID() {
        return this.actionID;
    }

    public void setID(String string) {
        this.actionID = string;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public void addEvent(String string) {
        this.events.add(string);
    }

    public void removeEvent(int n) {
        this.events.remove(n);
    }

    public void removeCommand(int n) {
        this.commands.remove(n);
    }

    public void addCommand(String string) {
        this.commands.add(string);
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<Tuple<IBloodmoonAction, Double>> getConvertedActions() {
        List<Tuple<String, Double>> list = this.convertList(this.events);
        ArrayList<Tuple<IBloodmoonAction, Double>> arrayList = new ArrayList<Tuple<IBloodmoonAction, Double>>();
        for (Tuple<String, Double> tuple : list) {
            String[] stringArray = tuple.getFirst().split(" ");
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            IBloodmoonAction iBloodmoonAction = Statics.getAction(stringArray[0]);
            iBloodmoonAction.setArgs(stringArray2);
            arrayList.add(new Tuple<IBloodmoonAction, Double>(iBloodmoonAction, tuple.getSecond()));
        }
        return arrayList;
    }

    public List<Tuple<String, Double>> getConvertedCommands() {
        return this.convertList(this.commands);
    }

    private List<Tuple<String, Double>> convertList(List<String> list) {
        ArrayList<Tuple<String, Double>> arrayList = new ArrayList<Tuple<String, Double>>();
        for (String string : list) {
            String[] stringArray = string.split(" ");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i]).append(" ");
            }
            try {
                Double d = Double.parseDouble(stringArray[stringArray.length - 1]);
                arrayList.add(new Tuple<String, Double>(stringBuilder.toString().trim(), d));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }
}

