/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.defaults;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrgeneralq.bloodmoon.statics.FiveTuple;
import me.mrgeneralq.bloodmoon.statics.Tuple;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;

@SerializableAs(value="DefaultLifecycle")
public class DefaultLifecycle
implements ConfigurationSerializable {
    private String lifecycleId;
    private List<String> actions;
    private List<String> deathActions;

    public DefaultLifecycle(Map<String, Object> map) {
        this.actions = map.getOrDefault("actions", new ArrayList());
        this.deathActions = map.getOrDefault("death", new ArrayList());
    }

    public DefaultLifecycle(String string) {
        this.lifecycleId = string;
        this.actions = new ArrayList<String>();
        this.deathActions = new ArrayList<String>();
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("actions", this.actions);
        hashMap.put("death", this.deathActions);
        return hashMap;
    }

    public String getID() {
        return this.lifecycleId;
    }

    public void setID(String string) {
        this.lifecycleId = string;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public List<String> getDeathActions() {
        return this.deathActions;
    }

    public List<FiveTuple<String, Double, Double, Double, Integer>> getConvertedLifecycle() {
        return this.convertList(this.actions);
    }

    private List<FiveTuple<String, Double, Double, Double, Integer>> convertList(List<String> list) {
        ArrayList<FiveTuple<String, Double, Double, Double, Integer>> arrayList = new ArrayList<FiveTuple<String, Double, Double, Double, Integer>>();
        for (String string : list) {
            String[] stringArray = string.split(" ");
            try {
                String string2 = stringArray[0];
                Double d = Double.parseDouble(stringArray[1]);
                Double d2 = Double.parseDouble(stringArray[2]);
                Double d3 = Double.parseDouble(stringArray[3]);
                Integer n = Integer.parseInt(stringArray[4]);
                arrayList.add(new FiveTuple<String, Double, Double, Double, Integer>(string2, d, d2, d3, n));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public List<Tuple<String, Double>> getConvertedDeathActions() {
        ArrayList<Tuple<String, Double>> arrayList = new ArrayList<Tuple<String, Double>>();
        for (String string : this.deathActions) {
            String[] stringArray = string.split(" ");
            try {
                String string2 = stringArray[0];
                Double d = Double.parseDouble(stringArray[1]);
                arrayList.add(new Tuple<String, Double>(string2, d));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public String toString() {
        return "DefaultLifecycle{lifecycleId='" + this.lifecycleId + '\'' + ", actions=" + this.actions + '}';
    }

    public void addAction(String string) {
        this.actions.add(string);
    }

    public void removeAction(int n) {
        this.actions.remove(n);
    }

    public void addDeatAction(String string) {
        this.deathActions.add(string);
    }

    public void removeDeatAction(int n) {
        this.deathActions.remove(n);
    }
}

