/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.defaults;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrgeneralq.bloodmoon.defaults.DefaultItem;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

@SerializableAs(value="DefaultMob")
public class DefaultMob
implements ConfigurationSerializable {
    private String mobID;
    private EntityType type = Statics.getEntityType("ZOMBIE");
    private double percentage = 100.0;
    private double speed = 0.1;
    private String name = "DEFAULT";
    private double health = 20.0;
    private double itemDropChange = 0.0;
    private boolean baby = false;
    private int size = 3;
    private int explosionRadius = 2;
    private boolean glowing = false;
    private boolean powered = false;
    private boolean angry = false;
    private boolean spawnOnSurface = false;
    private HashMap<String, String> items = new HashMap();
    private List<String> drops = new ArrayList<String>();
    private String lifecycle = null;
    private double damage = 2.0;
    private boolean boss = false;
    private String mythicmob = null;

    public DefaultMob(Map<String, Object> map) {
        this.type = Statics.getEntityType((String)map.getOrDefault("type", "ZOMBIE"));
        this.percentage = (Double)map.getOrDefault("percentage", 100.0);
        this.speed = (Double)map.getOrDefault("speed", 0.3);
        this.name = (String)map.getOrDefault("name", "DEFAULT");
        this.health = (Double)map.getOrDefault("health", 20.0);
        this.items = map.getOrDefault("items", new HashMap());
        this.itemDropChange = (Double)map.getOrDefault("item-drop-chance", 0.0);
        this.baby = (Boolean)map.getOrDefault("baby", false);
        this.size = (Integer)map.getOrDefault("size", 3);
        this.explosionRadius = (Integer)map.getOrDefault("explosion-radius", 2);
        this.powered = (Boolean)map.getOrDefault("powered", false);
        this.glowing = (Boolean)map.getOrDefault("glowing", false);
        this.angry = (Boolean)map.getOrDefault("angry", false);
        this.drops = map.getOrDefault("drops", new ArrayList());
        this.lifecycle = map.getOrDefault("lifecycle", null);
        this.damage = (Double)map.getOrDefault("damage", 2.0);
        this.boss = (Boolean)map.getOrDefault("boss", false);
        this.mythicmob = map.getOrDefault("mythicmob", null);
        this.spawnOnSurface = (Boolean)map.getOrDefault("surface-spawn", false);
    }

    public DefaultMob(String string, EntityType entityType) {
        this.mobID = string;
        this.type = entityType;
    }

    public DefaultMob(String string) {
        this.mobID = string;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double d) {
        this.percentage = d;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setHealth(double d) {
        this.health = d;
    }

    public double getHealth() {
        return this.health;
    }

    public boolean isBoss() {
        return this.boss;
    }

    public LivingEntity updateMob(LivingEntity livingEntity) {
        return livingEntity;
    }

    public void setType(EntityType entityType) {
        this.type = entityType;
    }

    public EntityType getType() {
        return this.type;
    }

    public HashMap<String, String> getItems() {
        return this.items;
    }

    public double getItemDropChange() {
        return this.itemDropChange;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", this.type.toString());
        hashMap.put("name", this.name);
        hashMap.put("percentage", this.percentage);
        hashMap.put("health", this.health);
        hashMap.put("speed", this.speed);
        hashMap.put("damage", this.damage);
        hashMap.put("glowing", this.glowing);
        hashMap.put("item-drop-chance", this.itemDropChange);
        hashMap.put("items", this.items);
        hashMap.put("drops", this.drops);
        hashMap.put("lifecycle", this.lifecycle);
        hashMap.put("boss", this.boss);
        hashMap.put("surface-spawn", this.spawnOnSurface);
        if (this.type == Statics.getEntityType("ZOMBIE") || this.type == Statics.getEntityType("WOLF")) {
            hashMap.put("baby", this.baby);
        }
        if (this.type == Statics.getEntityType("SLIME") || this.type == Statics.getEntityType("MAGMA_CUBE")) {
            hashMap.put("size", this.size);
        }
        if (this.type == Statics.getEntityType("CREEPER")) {
            hashMap.put("explosion-radius", this.explosionRadius);
            hashMap.put("powered", this.powered);
        }
        if (this.type == Statics.getEntityType("WOLF") || this.type == Statics.getEntityType("PIG_ZOMBIE")) {
            hashMap.put("angry", this.angry);
        }
        if (this.mythicmob != null) {
            hashMap.put("mythicmob", this.mythicmob);
        }
        return hashMap;
    }

    public static DefaultMob deserialize(Map<String, Object> map) {
        return new DefaultMob(map);
    }

    public static DefaultMob valueOf(Map<String, Object> map) {
        return new DefaultMob(map);
    }

    public String getMobID() {
        return this.mobID;
    }

    public void setMobID(String string) {
        this.mobID = string;
    }

    public boolean isBaby() {
        return this.baby;
    }

    public void setBaby(boolean bl) {
        this.baby = bl;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getExplosionRadius() {
        return this.explosionRadius;
    }

    public void setExplosionRadius(int n) {
        this.explosionRadius = n;
    }

    public List<String> getDrops() {
        return this.drops;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean bl) {
        this.glowing = bl;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean bl) {
        this.powered = bl;
    }

    public boolean isAngry() {
        return this.angry;
    }

    public void setAngry(boolean bl) {
        this.angry = bl;
    }

    public void setBoss(boolean bl) {
        this.boss = bl;
    }

    public void addDrop(DefaultItem defaultItem, int n, double d) {
        String string = String.format("%s %s %s", defaultItem.getItemId(), n, d);
        this.drops.add(string);
    }

    public void setLifecycle(String string) {
        this.lifecycle = string;
    }

    public String getLifecycleID() {
        return this.lifecycle;
    }

    public void addItem(String string, String string2) {
        this.items.put(string, string2);
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double d) {
        this.damage = d;
    }

    public void setMythicMob(String string) {
        this.mythicmob = string;
    }

    public String getMythicMob() {
        return this.mythicmob;
    }

    public boolean isSpawnOnSurface() {
        return this.spawnOnSurface;
    }

    public void setSpawnOnSurface(boolean bl) {
        this.spawnOnSurface = bl;
    }
}

