/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.Arrays;
import me.mrgeneralq.bloodmoon.BloodmoonCore;
import me.mrgeneralq.bloodmoon.events.BloodmoonStartEvent;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.ISoundService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class OnBloodmoonStart
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private final IMessageService messageService;
    private final ISoundService soundService;
    private final BloodmoonCore bloodmoonCore;

    public OnBloodmoonStart(IBloodmoonService iBloodmoonService, IConfigService iConfigService, IMessageService iMessageService, ISoundService iSoundService, BloodmoonCore bloodmoonCore) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.messageService = iMessageService;
        this.soundService = iSoundService;
        this.bloodmoonCore = bloodmoonCore;
    }

    @EventHandler
    public void onBloodmoonStart(BloodmoonStartEvent bloodmoonStartEvent) {
        Object object;
        World world = bloodmoonStartEvent.getBloodmoon().getWorld();
        final Bloodmoon bloodmoon = bloodmoonStartEvent.getBloodmoon();
        if (this.configService.isChangeDifficulty()) {
            bloodmoon.setDifficulty(this.configService.getDifficulty());
        }
        this.bloodmoonService.registerPlayersForBossBar(world);
        if (this.configService.isBossbarEnabled()) {
            bloodmoon.getBossbar().setVisible(true);
        }
        if (this.configService.isStartSoundEnabled()) {
            object = this.configService.getStartSound();
            for (Object object2 : bloodmoonStartEvent.getBloodmoon().getWorld().getPlayers()) {
                this.soundService.playSound((Player)object2, (String)object);
            }
        }
        if (this.configService.isRunStartCommands()) {
            for (String string : this.configService.getStartCommands()) {
                Object object2;
                object2 = Bukkit.getServer().getConsoleSender();
                if (string.toLowerCase().startsWith("bloodmoon say ")) {
                    Object object3 = string.replaceAll("%world%", world.getName()).split(" ");
                    Player player = (Player)Arrays.copyOfRange(object3, 2, ((Object)object3).length);
                    this.messageService.broadcast(bloodmoon.getWorld(), String.join((CharSequence)" ", (CharSequence[])player));
                    continue;
                }
                if (string.contains("%player%")) {
                    for (Player player : world.getPlayers()) {
                        Bukkit.dispatchCommand((CommandSender)object2, (String)string.replaceAll("%player%", player.getDisplayName()).replaceAll("%world%", world.getName()));
                    }
                    continue;
                }
                Bukkit.dispatchCommand((CommandSender)object2, (String)string.replaceAll("%world%", world.getName()));
            }
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.bloodmoonCore, new Runnable(){

                @Override
                public void run() {
                    if (OnBloodmoonStart.this.configService.isSetResourcePack()) {
                        bloodmoon.setResourcePackEnabled(true);
                    }
                }
            }, 20L);
            if (this.configService.startTitleEnabled()) {
                object = this.configService.getStartTitle();
                String string = this.configService.getStartSubTitle();
                for (Object object3 : world.getPlayers()) {
                    object3.sendTitle(Message.getMessage((String)object), string, 10, 70, 20);
                }
            }
        }
    }
}

