/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.List;
import java.util.Random;
import me.mrgeneralq.bloodmoon.factories.PlayerDeathActionFactory;
import me.mrgeneralq.bloodmoon.interfaces.actions.IPlayerDeathAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class OnPlayerDeath
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;
    private final PlayerDeathActionFactory deathActionFactory;

    public OnPlayerDeath(IBloodmoonService iBloodmoonService, IMessageService iMessageService) {
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
        this.deathActionFactory = PlayerDeathActionFactory.getFactory();
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        World world = player.getWorld();
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        List<String> list = this.deathActionFactory.getAllActionKeys();
        for (String string : list) {
            IPlayerDeathAction iPlayerDeathAction = this.deathActionFactory.getAction(string);
            Double d = new Random().nextDouble() * 100.0;
            if (d >= iPlayerDeathAction.getPercentage()) continue;
            iPlayerDeathAction.execute(playerDeathEvent);
        }
    }
}

