/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.factories.SignActionFactory;
import me.mrgeneralq.bloodmoon.interfaces.actions.ISignAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

public class OnSignCreate
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;
    private final SignActionFactory signActionFactory;

    public OnSignCreate(IBloodmoonService iBloodmoonService, IMessageService iMessageService) {
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
        this.signActionFactory = SignActionFactory.getFactory();
    }

    @EventHandler
    public void onSignCreate(SignChangeEvent signChangeEvent) {
        if (signChangeEvent.isCancelled()) {
            return;
        }
        Player player = signChangeEvent.getPlayer();
        String[] stringArray = signChangeEvent.getLines();
        String string2 = stringArray[1].toLowerCase();
        String string3 = stringArray[2].toLowerCase();
        String string4 = stringArray[3].toLowerCase();
        List list = Arrays.stream(signChangeEvent.getLines()).filter(string -> string.length() != 0).collect(Collectors.toList());
        if (list.size() == 0) {
            return;
        }
        String string5 = (String)list.get(0);
        if (!string5.equalsIgnoreCase("[bloodmoon]")) {
            return;
        }
        String string6 = String.format("bloodmoon.sign.create.%s", string2);
        if (!player.hasPermission(string6)) {
            player.sendMessage(this.messageService.getMessage(Message.signNoPermissionToCreate, true));
            signChangeEvent.setCancelled(true);
            return;
        }
        if (list.size() < 2) {
            player.sendMessage(this.messageService.getMessage("sign-action-parameter-missing", true));
            signChangeEvent.setCancelled(true);
            return;
        }
        if (!this.signActionFactory.actionExists(string2.toLowerCase())) {
            player.sendMessage(this.messageService.getMessage("sign-action-not-exist", true));
            signChangeEvent.setCancelled(true);
            return;
        }
        ISignAction iSignAction = this.signActionFactory.getAction(string2);
        if (!iSignAction.isValidCreation(signChangeEvent)) {
            signChangeEvent.setCancelled(true);
            return;
        }
        signChangeEvent.setLine(0, Message.getMessage("&4[bloodmoon]"));
        signChangeEvent.setLine(1, string2.toLowerCase());
        signChangeEvent.setLine(2, string3.toLowerCase());
        signChangeEvent.setLine(3, string4.toLowerCase());
        player.sendMessage(this.messageService.getMessage("sign-created", true));
    }
}

