/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.factories.SignActionFactory;
import me.mrgeneralq.bloodmoon.interfaces.actions.ISignAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class OnSignInteract
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;
    private final SignActionFactory signActionFactory;

    public OnSignInteract(IBloodmoonService iBloodmoonService, IMessageService iMessageService) {
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
        this.signActionFactory = SignActionFactory.getFactory();
    }

    @EventHandler
    public void onSignInteract(PlayerInteractEvent playerInteractEvent) {
        Block block = playerInteractEvent.getClickedBlock();
        Player player = playerInteractEvent.getPlayer();
        if (block == null || block.getType() == Material.AIR) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Sign sign = (Sign)block.getState();
        String[] stringArray = sign.getLines();
        List list = Arrays.stream(sign.getLines()).filter(string -> string.length() != 0).collect(Collectors.toList());
        if (list.size() == 0) {
            return;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        if (!string2.equalsIgnoreCase(Message.getMessage("&4[bloodmoon]"))) {
            return;
        }
        if (list.size() < 2) {
            player.sendMessage(this.messageService.getMessage("sign-action-parameter-missing", true));
            playerInteractEvent.setCancelled(true);
            return;
        }
        String string6 = String.format("bloodmoon.sign.use.%s", string3);
        if (!player.hasPermission(string6)) {
            player.sendMessage(this.messageService.getMessage(Message.signNoPermissionToUse, true));
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (!this.signActionFactory.actionExists(string3)) {
            player.sendMessage(this.messageService.getMessage(Message.signNotExist, true));
            playerInteractEvent.setCancelled(true);
            return;
        }
        ISignAction iSignAction = this.signActionFactory.getAction(string3.toLowerCase());
        iSignAction.executeAction(playerInteractEvent);
    }
}

