/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.repositories;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.mrgeneralq.bloodmoon.defaults.DefaultItem;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IItemRepository;
import me.mrgeneralq.bloodmoon.statics.ConfigManager;
import me.mrgeneralq.bloodmoon.statics.ItemStackSerializer;
import me.mrgeneralq.bloodmoon.statics.YamlManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class ItemRepository
implements IItemRepository {
    private YamlConfiguration config;
    private final ConfigManager configManager;
    private final Map<String, ItemStack> items = new HashMap<String, ItemStack>();
    private YamlManager yaml;

    public ItemRepository() {
        this.configManager = ConfigManager.getManager();
        this.config = this.configManager.getConfig("items");
        this.yaml = YamlManager.getYaml();
        this.reloadConfig();
    }

    @Override
    public DefaultItem get(String string) {
        if (!this.yaml.exists(this.config, this.getItemPath(string))) {
            return null;
        }
        DefaultItem defaultItem = null;
        try {
            defaultItem = new DefaultItem(string, this.items.get(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultItem;
    }

    @Override
    public void addOrUpdate(DefaultItem defaultItem) {
        this.items.put(defaultItem.getItemId(), defaultItem.getItem());
        this.config.set(this.getItemPath(defaultItem.getItemId()), (Object)ItemStackSerializer.serialize(defaultItem.getItem()));
        this.configManager.saveConfig(this.config, "items");
    }

    @Override
    public Set<String> getSectionList(String string) {
        return this.config.getConfigurationSection(string).getKeys(false);
    }

    @Override
    public void remove(String string) {
        this.items.remove(string);
        this.config.set(String.format("items.%s", string), null);
        this.configManager.saveConfig(this.config, "items");
    }

    @Override
    public void reloadConfig() {
        this.config = this.configManager.reloadConfig("items");
        this.loadItemsToMemory();
    }

    private String getItemPath(String string) {
        return String.format("items.%s", string);
    }

    public void loadItemsToMemory() {
        this.items.clear();
        for (String string : this.config.getConfigurationSection("items").getKeys(false)) {
            try {
                ItemStack itemStack = ItemStackSerializer.deserialize(this.config.getString(this.getItemPath(string)));
                this.items.put(string, itemStack);
            }
            catch (Exception exception) {
                Bukkit.getLogger().severe(String.format("[Bloodmoon] failed to parse item %s", string));
            }
        }
    }
}

