/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.repositories;

import java.util.Map;
import java.util.Set;
import me.mrgeneralq.bloodmoon.defaults.DefaultLifecycle;
import me.mrgeneralq.bloodmoon.interfaces.repositories.ILifeCycleRepository;
import me.mrgeneralq.bloodmoon.statics.ConfigManager;
import me.mrgeneralq.bloodmoon.statics.YamlManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class LifeCycleRepository
implements ILifeCycleRepository {
    private YamlConfiguration config;
    private final ConfigManager configManager = ConfigManager.getManager();
    private YamlManager yaml;

    public LifeCycleRepository() {
        this.config = this.configManager.getConfig("lifecycles");
        this.yaml = YamlManager.getYaml();
    }

    @Override
    public DefaultLifecycle get(String string) {
        if (!this.yaml.exists(this.config, this.getLifeCyclePath(string))) {
            return null;
        }
        try {
            DefaultLifecycle defaultLifecycle;
            ConfigurationSection configurationSection = this.config.getConfigurationSection(this.getLifeCyclePath(string));
            if (configurationSection == null) {
                Map map = (Map)this.config.get(this.getLifeCyclePath(string));
                defaultLifecycle = new DefaultLifecycle(map);
            } else {
                Map map = configurationSection.getValues(false);
                defaultLifecycle = new DefaultLifecycle(map);
            }
            defaultLifecycle.setID(string);
            return defaultLifecycle;
        }
        catch (Exception exception) {
            Bukkit.getLogger().warning("[bloodmoon] lifecycle.yml is invalid");
            return null;
        }
    }

    @Override
    public Set<String> getSectionList(String string) {
        return this.config.getConfigurationSection(string).getKeys(false);
    }

    @Override
    public void addOrUpdate(DefaultLifecycle defaultLifecycle) {
        this.config.set(this.getLifeCyclePath(defaultLifecycle.getID()), defaultLifecycle.serialize());
        this.configManager.saveConfig(this.config, "lifecycles");
    }

    @Override
    public void remove(String string) {
        this.config.set(this.getLifeCyclePath(string), null);
        this.configManager.saveConfig(this.config, "lifecycles");
    }

    @Override
    public void reloadConfig() {
        this.config = this.configManager.reloadConfig("lifecycles");
    }

    private String getLifeCyclePath(String string) {
        return String.format("cycles.%s", string);
    }
}

