/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.repositories;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IMobRepository;
import me.mrgeneralq.bloodmoon.models.LifeCycle;
import me.mrgeneralq.bloodmoon.statics.ConfigManager;
import me.mrgeneralq.bloodmoon.statics.YamlManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MobRepository
implements IMobRepository {
    private YamlConfiguration config;
    private final ConfigManager configManager;
    private YamlManager yaml;
    private final Plugin plugin;
    private boolean bossUsed;
    private HashMap<UUID, Date> pathDelays;
    private HashMap<UUID, LifeCycle> lifecycles;

    public MobRepository(Plugin plugin) {
        this.plugin = plugin;
        this.configManager = ConfigManager.getManager();
        this.config = this.configManager.getConfig("mobs");
        this.yaml = YamlManager.getYaml();
        this.lifecycles = new HashMap();
        this.bossUsed = false;
        this.pathDelays = new HashMap();
    }

    @Override
    public DefaultMob get(String string) {
        if (!this.yaml.exists(this.config, this.getMobPath(string))) {
            return null;
        }
        try {
            DefaultMob defaultMob;
            ConfigurationSection configurationSection = this.config.getConfigurationSection(this.getMobPath(string));
            if (configurationSection == null) {
                Map map = (Map)this.config.get(this.getMobPath(string));
                defaultMob = new DefaultMob(map);
            } else {
                Map map = configurationSection.getValues(false);
                if (map.get("items") != null) {
                    map.put("items", ((MemorySection)map.get("items")).getValues(false));
                }
                defaultMob = new DefaultMob(map);
            }
            defaultMob.setMobID(string);
            return defaultMob;
        }
        catch (Exception exception) {
            Bukkit.getLogger().warning("[bloodmoon] mobs.yml is invalid");
            return null;
        }
    }

    @Override
    public void addOrUpdate(DefaultMob defaultMob) {
        this.config.set(this.getMobPath(defaultMob.getMobID()), defaultMob.serialize());
        this.configManager.saveConfig(this.config, "mobs");
    }

    @Override
    public void remove(String string) {
        this.config.set(String.format("mobs.%s", string), null);
        this.configManager.saveConfig(this.config, "mobs");
    }

    @Override
    public Set<String> getSectionList(String string) {
        return this.config.getConfigurationSection(string).getKeys(false);
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void addLifecycle(UUID uUID, LifeCycle lifeCycle) {
        this.lifecycles.put(uUID, lifeCycle);
    }

    @Override
    public void resetLifeCyles() {
        this.lifecycles.clear();
    }

    @Override
    public LifeCycle getLifeCycle(UUID uUID) {
        return this.lifecycles.get(uUID);
    }

    @Override
    public void reloadConfig() {
        this.config = this.configManager.reloadConfig("mobs");
    }

    @Override
    public void bossUsed(boolean bl) {
        this.bossUsed = bl;
    }

    @Override
    public boolean getBossUsed() {
        return this.bossUsed;
    }

    @Override
    public void addPathDelay(Player player) {
        this.pathDelays.put(player.getUniqueId(), new Date());
    }

    @Override
    public boolean canUsePath(Player player, int n) {
        if (!this.pathDelays.containsKey(player.getUniqueId())) {
            return true;
        }
        Date date = this.pathDelays.getOrDefault(player.getUniqueId(), new Date());
        long l = (new Date().getTime() - date.getTime()) / 1000L;
        if (l > (long)n) {
            this.pathDelays.remove(player.getUniqueId());
            return true;
        }
        return false;
    }

    @Override
    public void resetPathDelays() {
        this.pathDelays.clear();
    }

    private String getMobPath(String string) {
        return String.format("mobs.%s", string);
    }
}

