/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.runnables;

import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;

public class NightTimer
extends BukkitRunnable {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private int counter = 0;
    private double rest = 0.0;

    public NightTimer(IBloodmoonService iBloodmoonService, IConfigService iConfigService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
    }

    public void run() {
        for (World world : Bukkit.getWorlds()) {
            if (!this.bloodmoonService.isNight(world)) {
                return;
            }
            if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
                return;
            }
            if (!this.configService.longerNightsEnabled()) {
                return;
            }
            double d = this.configService.nightsBoostPercentage() / 100.0;
            double d2 = Math.floor(1.0 + d);
            double d3 = (int)((d + 0.001) * 100.0) % 100;
            if (d3 != 0.0) {
                this.rest += d3 / 100.0;
            }
            if ((double)this.counter >= d2 && this.rest < 1.0) {
                world.setTime(world.getTime() + 1L);
                this.counter = 0;
                return;
            }
            if (this.rest >= 1.0) {
                this.rest -= 1.0;
            }
            ++this.counter;
        }
    }
}

