/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.services;

import java.util.HashMap;
import java.util.Set;
import me.mrgeneralq.bloodmoon.enums.BloodmoonScheduleCause;
import me.mrgeneralq.bloodmoon.enums.DataModification;
import me.mrgeneralq.bloodmoon.events.BloodmoonScheduleEvent;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IScheduleRepository;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;

public class BloodmoonScheduleService
implements IBloodmoonScheduleService {
    private final HashMap<World, BloodmoonSchedule> scheduleMemory = new HashMap();
    private final IScheduleRepository repository;
    private final IBloodmoonService bloodmoonService;

    public BloodmoonScheduleService(IScheduleRepository iScheduleRepository, IBloodmoonService iBloodmoonService) {
        this.repository = iScheduleRepository;
        this.bloodmoonService = iBloodmoonService;
    }

    @Override
    public void addSchedule(BloodmoonSchedule bloodmoonSchedule, DataModification dataModification) {
        this.scheduleMemory.put(bloodmoonSchedule.getWorld(), bloodmoonSchedule);
        if (dataModification == DataModification.REPOSITORY || dataModification == DataModification.ALL) {
            this.repository.addOrUpdate(bloodmoonSchedule);
        }
    }

    @Override
    public BloodmoonSchedule getSchedule(World world) {
        return this.scheduleMemory.get(world);
    }

    @Override
    public BloodmoonSchedule getScheduleFromRepo(World world) {
        return this.repository.get(world);
    }

    @Override
    public BloodmoonSchedule getScheduleFromRepo(String string) {
        return this.repository.get(string);
    }

    @Override
    public boolean scheduleExists(World world) {
        return this.repository.get(world) != null;
    }

    @Override
    public void loadMemory() {
        for (String string : this.repository.getSectionList()) {
            if (Bukkit.getWorld((String)string) == null) continue;
            World world = Bukkit.getWorld((String)string);
            BloodmoonSchedule bloodmoonSchedule = this.repository.get(world);
            this.scheduleMemory.put(world, bloodmoonSchedule);
        }
    }

    @Override
    public void removeSchedule(World world, DataModification dataModification) {
        this.scheduleMemory.remove(world);
        if (dataModification == DataModification.REPOSITORY || dataModification == DataModification.ALL) {
            this.repository.remove(world);
        }
    }

    @Override
    public Set<String> getAllScheduleIds() {
        return this.repository.getSectionList();
    }

    @Override
    public boolean isScheduled(World world) {
        return this.scheduleMemory.containsKey(world);
    }

    @Override
    public void callScheduleEvent(Bloodmoon bloodmoon, BloodmoonScheduleCause bloodmoonScheduleCause) {
        Bukkit.getPluginManager().callEvent((Event)new BloodmoonScheduleEvent(bloodmoon, bloodmoonScheduleCause));
    }

    @Override
    public void reloadConfig() {
        this.repository.reloadConfig();
        this.loadMemory();
    }
}

