/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core;

import com.willfp.eco.core.proxy.ProxyConstants;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class Prerequisite {
    private static final List<Prerequisite> VALUES = new ArrayList<Prerequisite>();
    public static final Prerequisite HAS_PAPER = new Prerequisite(() -> ClassUtils.exists("com.destroystokyo.paper.event.block.BeaconEffectEvent"), "Requires server to be running paper (or a fork)");
    public static final Prerequisite HAS_PROTOCOLLIB = new Prerequisite(() -> ClassUtils.exists("com.comphenix.protocol.events.PacketAdapter"), "Requires server to have ProtocolLib");
    public static final Prerequisite HAS_1_20_3 = new Prerequisite(() -> ProxyConstants.NMS_VERSION.contains("20_R3"), "Requires server to be running 1.20.3+");
    public static final Prerequisite HAS_1_20 = new Prerequisite(() -> ProxyConstants.NMS_VERSION.contains("20"), "Requires server to be running 1.20+");
    public static final Prerequisite HAS_1_19_4 = new Prerequisite(() -> ProxyConstants.NMS_VERSION.contains("19_R3") || HAS_1_20.isMet(), "Requires server to be running 1.19.4+");
    public static final Prerequisite HAS_1_19 = new Prerequisite(() -> ProxyConstants.NMS_VERSION.contains("19") || HAS_1_20.isMet(), "Requires server to be running 1.19+");
    public static final Prerequisite HAS_1_18 = new Prerequisite(() -> ProxyConstants.NMS_VERSION.contains("18") || HAS_1_19.isMet(), "Requires server to be running 1.18+");
    @Deprecated(since="6.49.0", forRemoval=true)
    public static final Prerequisite HAS_BUNGEECORD = new Prerequisite(() -> ClassUtils.exists("net.md_5.bungee.api.event.ServerConnectedEvent"), "Requires server to be running BungeeCord (or a fork)");
    @Deprecated(since="6.49.0", forRemoval=true)
    public static final Prerequisite HAS_VELOCITY = new Prerequisite(() -> ClassUtils.exists("com.velocitypowered.api.event.player.ServerConnectedEvent"), "Requires server to be running Velocity (or a fork)");
    private boolean isMet;
    private final Supplier<Boolean> isMetSupplier;
    private final String description;

    public Prerequisite(@NotNull Supplier<Boolean> isMetSupplier, @NotNull String description2) {
        this.isMetSupplier = isMetSupplier;
        this.isMet = isMetSupplier.get();
        this.description = description2;
        VALUES.add(this);
    }

    private void refresh() {
        this.isMet = this.isMetSupplier.get();
    }

    public static void update() {
        VALUES.forEach(Prerequisite::refresh);
    }

    public static boolean areMet(@NotNull Prerequisite[] prerequisites) {
        Prerequisite.update();
        return Arrays.stream(prerequisites).allMatch(Prerequisite::isMet);
    }

    public boolean isMet() {
        return this.isMet;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        Prerequisite.update();
    }
}

