/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.config;

import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.Configs;
import com.willfp.eco.core.config.DSLConfig;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.ConfigurationSection;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\u001a)\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u001a\u000b\u0010\t\u001a\u00070\u0001\u00a2\u0006\u0002\b\n\u001a\u0013\u0010\t\u001a\u00070\u0001\u00a2\u0006\u0002\b\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001f\u0010\u000b\u001a\u00020\u00012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u001a\u001b\u0010\f\u001a\u00070\u0001\u00a2\u0006\u0002\b\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0011\u0010\f\u001a\u00070\u0001\u00a2\u0006\u0002\b\n*\u0004\u0018\u00010\u000f\u001a\u0019\u0010\f\u001a\u00070\u0001\u00a2\u0006\u0002\b\n*\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0011\u0010\f\u001a\u00070\u0001\u00a2\u0006\u0002\b\n*\u0004\u0018\u00010\u0010\u001a\u001f\u0010\u0011\u001a\u00070\u0001\u00a2\u0006\u0002\b\n*\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u001a'\u0010\u0011\u001a\u00070\u0001\u00a2\u0006\u0002\b\n*\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0011\u0010\u0011\u001a\u00070\u0001\u00a2\u0006\u0002\b\n*\u0004\u0018\u00010\u0014\u00a8\u0006\u0015"}, d2={"config", "Lcom/willfp/eco/core/config/interfaces/Config;", "type", "Lcom/willfp/eco/core/config/ConfigType;", "builder", "Lkotlin/Function1;", "Lcom/willfp/eco/core/config/DSLConfig;", "", "Lkotlin/ExtensionFunctionType;", "emptyConfig", "Lcom/willfp/eco/libs/jetbrains/annotations/NotNull;", "json", "readConfig", "contents", "", "Ljava/io/File;", "Ljava/io/InputStream;", "toConfig", "", "", "Lorg/bukkit/configuration/ConfigurationSection;", "eco-api"})
@JvmName(name="ConfigExtensions")
public final class ConfigExtensions {
    @NotNull
    public static final Config config(@NotNull ConfigType type2, @NotNull Function1<? super DSLConfig, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(builder, "builder");
        DSLConfig dSLConfig = new DSLConfig(type2);
        builder.invoke(dSLConfig);
        return dSLConfig;
    }

    public static /* synthetic */ Config config$default(ConfigType configType, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            configType = ConfigType.YAML;
        }
        return ConfigExtensions.config(configType, function1);
    }

    @NotNull
    public static final Config json(@NotNull Function1<? super DSLConfig, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        return ConfigExtensions.config(ConfigType.JSON, builder);
    }

    @NotNull
    public static final Config emptyConfig() {
        Config config = Configs.empty();
        Intrinsics.checkNotNullExpressionValue(config, "empty(...)");
        return config;
    }

    @NotNull
    public static final Config emptyConfig(@NotNull ConfigType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Config config = Configs.empty(type2);
        Intrinsics.checkNotNullExpressionValue(config, "empty(...)");
        return config;
    }

    @NotNull
    public static final Config toConfig(@Nullable ConfigurationSection $this$toConfig) {
        Config config = Configs.fromBukkit($this$toConfig);
        Intrinsics.checkNotNullExpressionValue(config, "fromBukkit(...)");
        return config;
    }

    @NotNull
    public static final Config readConfig(@Nullable InputStream $this$readConfig) {
        Config config = Configs.fromStream($this$readConfig);
        Intrinsics.checkNotNullExpressionValue(config, "fromStream(...)");
        return config;
    }

    @NotNull
    public static final Config readConfig(@Nullable File $this$readConfig) {
        Config config = Configs.fromFile($this$readConfig);
        Intrinsics.checkNotNullExpressionValue(config, "fromFile(...)");
        return config;
    }

    @NotNull
    public static final Config readConfig(@Nullable File $this$readConfig, @NotNull ConfigType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Config config = Configs.fromFile($this$readConfig, type2);
        Intrinsics.checkNotNullExpressionValue(config, "fromFile(...)");
        return config;
    }

    @NotNull
    public static final Config toConfig(@NotNull Map<String, ? extends Object> $this$toConfig) {
        Intrinsics.checkNotNullParameter($this$toConfig, "<this>");
        Config config = Configs.fromMap($this$toConfig);
        Intrinsics.checkNotNullExpressionValue(config, "fromMap(...)");
        return config;
    }

    @NotNull
    public static final Config toConfig(@NotNull Map<String, ? extends Object> $this$toConfig, @NotNull ConfigType type2) {
        Intrinsics.checkNotNullParameter($this$toConfig, "<this>");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Config config = Configs.fromMap($this$toConfig, type2);
        Intrinsics.checkNotNullExpressionValue(config, "fromMap(...)");
        return config;
    }

    @NotNull
    public static final Config readConfig(@NotNull String contents, @NotNull ConfigType type2) {
        Intrinsics.checkNotNullParameter(contents, "contents");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Config config = Configs.fromString(contents, type2);
        Intrinsics.checkNotNullExpressionValue(config, "fromString(...)");
        return config;
    }
}

