/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.config.interfaces;

import com.willfp.eco.core.config.BuildableConfig;
import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.Configs;
import com.willfp.eco.core.placeholder.AdditionalPlayer;
import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.PlaceholderInjectable;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NumberUtils;
import com.willfp.eco.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public interface Config
extends Cloneable,
PlaceholderInjectable {
    public String toPlaintext();

    public boolean has(@NotNull String var1);

    @NotNull
    public List<String> getKeys(boolean var1);

    @NotNull
    default public List<String> recurseKeys(@NotNull Set<String> found, @NotNull String root) {
        return new ArrayList<String>();
    }

    @Nullable
    public Object get(@NotNull String var1);

    public void set(@NotNull String var1, @Nullable Object var2);

    @NotNull
    default public Config getSubsection(@NotNull String path) {
        return Objects.requireNonNullElse(this.getSubsectionOrNull(path), Configs.empty());
    }

    @Nullable
    public Config getSubsectionOrNull(@NotNull String var1);

    default public int getInt(@NotNull String path) {
        return Objects.requireNonNullElse(this.getIntOrNull(path), 0);
    }

    default public int getInt(@NotNull String path, int def) {
        return Objects.requireNonNullElse(this.getIntOrNull(path), def);
    }

    default public int getIntFromExpression(@NotNull String path) {
        return this.getIntFromExpression(path, PlaceholderContext.of(this));
    }

    default public int getIntFromExpression(@NotNull String path, @Nullable Player player) {
        return Double.valueOf(this.getDoubleFromExpression(path, player)).intValue();
    }

    default public int getIntFromExpression(@NotNull String path, @Nullable Player player, @NotNull Collection<AdditionalPlayer> additionalPlayers) {
        return Double.valueOf(this.getDoubleFromExpression(path, player, additionalPlayers)).intValue();
    }

    default public int getIntFromExpression(@NotNull String path, @NotNull PlaceholderContext context) {
        return Double.valueOf(this.getDoubleFromExpression(path, context)).intValue();
    }

    @Nullable
    public Integer getIntOrNull(@NotNull String var1);

    @NotNull
    default public List<Integer> getInts(@NotNull String path) {
        return Objects.requireNonNullElse(this.getIntsOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Integer> getIntsOrNull(@NotNull String var1);

    default public boolean getBool(@NotNull String path) {
        return Objects.requireNonNullElse(this.getBoolOrNull(path), false);
    }

    @Nullable
    public Boolean getBoolOrNull(@NotNull String var1);

    @NotNull
    default public List<Boolean> getBools(@NotNull String path) {
        return Objects.requireNonNullElse(this.getBoolsOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Boolean> getBoolsOrNull(@NotNull String var1);

    @NotNull
    default public String getFormattedString(@NotNull String path) {
        return this.getString(path, true, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    @NotNull
    default public String getFormattedString(@NotNull String path, @NotNull StringUtils.FormatOption option) {
        return this.getString(path, true, option);
    }

    @NotNull
    default public String getFormattedString(@NotNull String path, @NotNull PlaceholderContext context) {
        return Objects.requireNonNullElse(this.getFormattedStringOrNull(path, context), "");
    }

    @NotNull
    default public String getString(@NotNull String path) {
        return this.getString(path, false, StringUtils.FormatOption.WITHOUT_PLACEHOLDERS);
    }

    @NotNull
    default public String getString(@NotNull String path, boolean format, @NotNull StringUtils.FormatOption option) {
        return Objects.requireNonNullElse(this.getStringOrNull(path, format, option), "");
    }

    @Nullable
    default public String getFormattedStringOrNull(@NotNull String path) {
        return this.getStringOrNull(path, true, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    @Nullable
    default public String getFormattedStringOrNull(@NotNull String path, @NotNull StringUtils.FormatOption option) {
        return this.getStringOrNull(path, true, option);
    }

    @Nullable
    default public String getFormattedStringOrNull(@NotNull String path, @NotNull PlaceholderContext context) {
        String nullable = this.getStringOrNull(path);
        if (nullable == null) {
            return null;
        }
        return StringUtils.format(nullable, context.withInjectableContext(this));
    }

    @Nullable
    default public String getStringOrNull(@NotNull String path) {
        return this.getStringOrNull(path, false, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    @Nullable
    public String getStringOrNull(@NotNull String var1, boolean var2, @NotNull StringUtils.FormatOption var3);

    @NotNull
    default public List<String> getFormattedStrings(@NotNull String path) {
        return this.getStrings(path, true, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    @NotNull
    default public List<String> getFormattedStrings(@NotNull String path, @NotNull StringUtils.FormatOption option) {
        return this.getStrings(path, true, option);
    }

    @NotNull
    default public List<String> getFormattedStrings(@NotNull String path, @NotNull PlaceholderContext context) {
        return Objects.requireNonNullElse(this.getFormattedStringsOrNull(path, context), new ArrayList());
    }

    @NotNull
    default public List<String> getStrings(@NotNull String path) {
        return this.getStrings(path, false, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    @NotNull
    default public List<String> getStrings(@NotNull String path, boolean format, @NotNull StringUtils.FormatOption option) {
        return Objects.requireNonNullElse(this.getStringsOrNull(path, format, option), new ArrayList());
    }

    @Nullable
    default public List<String> getFormattedStringsOrNull(@NotNull String path) {
        return this.getStringsOrNull(path, true, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    @Nullable
    default public List<String> getFormattedStringsOrNull(@NotNull String path, @NotNull StringUtils.FormatOption option) {
        return this.getStringsOrNull(path, true, option);
    }

    @Nullable
    default public List<String> getFormattedStringsOrNull(@NotNull String path, @NotNull PlaceholderContext context) {
        List<String> nullable = this.getStringsOrNull(path);
        if (nullable == null) {
            return null;
        }
        return StringUtils.formatList(nullable, context.withInjectableContext(this));
    }

    @Nullable
    default public List<String> getStringsOrNull(@NotNull String path) {
        return this.getStringsOrNull(path, false, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    @Nullable
    public List<String> getStringsOrNull(@NotNull String var1, boolean var2, @NotNull StringUtils.FormatOption var3);

    default public double getDouble(@NotNull String path) {
        return Objects.requireNonNullElse(this.getDoubleOrNull(path), 0.0);
    }

    default public double getDoubleFromExpression(@NotNull String path) {
        return this.getDoubleFromExpression(path, PlaceholderContext.of(this));
    }

    default public double getDoubleFromExpression(@NotNull String path, @Nullable Player player) {
        return this.getDoubleFromExpression(path, player, Collections.emptyList());
    }

    default public double getDoubleFromExpression(@NotNull String path, @Nullable Player player, @NotNull Collection<AdditionalPlayer> additionalPlayers) {
        return this.getDoubleFromExpression(path, new PlaceholderContext(player, null, this, additionalPlayers));
    }

    default public double getDoubleFromExpression(@NotNull String path, @NotNull PlaceholderContext context) {
        return Objects.requireNonNullElseGet(this.getDoubleOrNull(path), () -> NumberUtils.evaluateExpression(this.getString(path), context.withInjectableContext(this)));
    }

    @Nullable
    public Double getDoubleOrNull(@NotNull String var1);

    @NotNull
    default public List<Double> getDoubles(@NotNull String path) {
        return Objects.requireNonNullElse(this.getDoublesOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Double> getDoublesOrNull(@NotNull String var1);

    @NotNull
    default public List<? extends Config> getSubsections(@NotNull String path) {
        return Objects.requireNonNullElse(this.getSubsectionsOrNull(path), new ArrayList());
    }

    @Nullable
    public List<? extends Config> getSubsectionsOrNull(@NotNull String var1);

    @NotNull
    default public BigDecimal getBigDecimal(@NotNull String path) {
        return Objects.requireNonNullElse(this.getBigDecimalOrNull(path), BigDecimal.ZERO);
    }

    @Nullable
    default public BigDecimal getBigDecimalOrNull(@NotNull String path) {
        if (this.has(path)) {
            return new BigDecimal(this.getString(path));
        }
        return null;
    }

    @NotNull
    public ConfigType getType();

    public Config clone();

    @Override
    default public void addInjectablePlaceholder(@NotNull Iterable<InjectablePlaceholder> placeholders) {
    }

    @Override
    @NotNull
    default public List<InjectablePlaceholder> getPlaceholderInjections() {
        return Collections.emptyList();
    }

    @Override
    default public void clearInjectedPlaceholders() {
    }

    default public Map<String, Object> toMap() {
        return new HashMap<String, Object>();
    }

    default public ConfigurationSection toBukkit() {
        YamlConfiguration empty2 = new YamlConfiguration();
        empty2.createSection("temp", this.toMap());
        return empty2.getConfigurationSection("temp");
    }

    public static BuildableConfig builder() {
        return new BuildableConfig();
    }
}

