/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.display;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.display.DisplayModule;
import com.willfp.eco.core.display.DisplayProperties;
import com.willfp.eco.core.fast.FastItemStack;
import com.willfp.eco.core.integrations.guidetection.GUIDetectionManager;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NamespacedKeyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public final class Display {
    public static final String PREFIX = "\u00a7z";
    private static final Map<Integer, List<DisplayModule>> REGISTERED_MODULES = new TreeMap<Integer, List<DisplayModule>>();
    private static final NamespacedKey FINALIZE_KEY = NamespacedKeyUtils.createEcoKey("finalized");

    public static ItemStack display(@NotNull ItemStack itemStack) {
        return Display.display(itemStack, null);
    }

    public static ItemStack display(@NotNull ItemStack itemStack, @Nullable Player player) {
        HashMap<String, Object[]> pluginVarArgs = new HashMap<String, Object[]>();
        for (List<DisplayModule> modules : REGISTERED_MODULES.values()) {
            for (DisplayModule module : modules) {
                pluginVarArgs.put(module.getPluginName(), module.generateVarArgs(itemStack));
            }
        }
        Display.revert(itemStack);
        if (!Eco.get().getEcoPlugin().getConfigYml().getBool("display-without-meta") && !itemStack.hasItemMeta()) {
            return itemStack;
        }
        ItemStack original = itemStack.clone();
        Inventory inventory = player == null ? null : player.getOpenInventory().getTopInventory();
        boolean inInventory = inventory != null && inventory.contains(original);
        boolean inGui = player != null && GUIDetectionManager.hasGUIOpen(player);
        DisplayProperties properties2 = new DisplayProperties(inInventory, inGui, original);
        for (List<DisplayModule> modules : REGISTERED_MODULES.values()) {
            for (DisplayModule module : modules) {
                Object[] varargs = (Object[])pluginVarArgs.get(module.getPluginName());
                if (varargs == null) continue;
                module.display(itemStack, varargs);
                if (player == null) continue;
                module.display(itemStack, player, varargs);
                module.display(itemStack, player, properties2, varargs);
            }
        }
        return itemStack;
    }

    public static ItemStack displayAndFinalize(@NotNull ItemStack itemStack) {
        return Display.finalize(Display.display(itemStack, null));
    }

    public static ItemStack displayAndFinalize(@NotNull ItemStack itemStack, @Nullable Player player) {
        return Display.finalize(Display.display(itemStack, player));
    }

    public static ItemStack revert(@NotNull ItemStack itemStack) {
        FastItemStack fast;
        List<String> lore;
        if (Display.isFinalized(itemStack)) {
            Display.unfinalize(itemStack);
        }
        if (!(lore = (fast = FastItemStack.wrap(itemStack)).getLore()).isEmpty() && lore.removeIf(line -> line.startsWith(PREFIX))) {
            fast.setLore(lore);
        }
        for (List<DisplayModule> modules : REGISTERED_MODULES.values()) {
            for (DisplayModule module : modules) {
                module.revert(itemStack);
            }
        }
        return itemStack;
    }

    public static ItemStack finalize(@NotNull ItemStack itemStack) {
        if (itemStack.getType().getMaxStackSize() > 1) {
            return itemStack;
        }
        FastItemStack.wrap(itemStack).getPersistentDataContainer().set(FINALIZE_KEY, PersistentDataType.INTEGER, (Object)1);
        return itemStack;
    }

    public static ItemStack unfinalize(@NotNull ItemStack itemStack) {
        FastItemStack.wrap(itemStack).getPersistentDataContainer().remove(FINALIZE_KEY);
        return itemStack;
    }

    public static boolean isFinalized(@NotNull ItemStack itemStack) {
        return FastItemStack.wrap(itemStack).getPersistentDataContainer().has(FINALIZE_KEY, PersistentDataType.INTEGER);
    }

    public static void registerDisplayModule(@NotNull DisplayModule module) {
        List modules = REGISTERED_MODULES.getOrDefault(module.getWeight(), new ArrayList());
        modules.removeIf(it -> it.getPluginName().equalsIgnoreCase(module.getPluginName()));
        modules.add(module);
        REGISTERED_MODULES.put(module.getWeight(), modules);
    }

    private Display() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

