/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.drops;

import com.willfp.eco.core.Eco;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DropQueue {
    private final DropQueue delegate;

    public DropQueue(@NotNull Player player) {
        this.delegate = Eco.get().createDropQueue(player);
    }

    protected DropQueue() {
        this.delegate = null;
    }

    public DropQueue addItem(@NotNull ItemStack item) {
        if (this.delegate == null) {
            return this;
        }
        this.delegate.addItem(item);
        return this;
    }

    public DropQueue addItems(@NotNull Collection<ItemStack> itemStacks) {
        if (this.delegate == null) {
            return this;
        }
        this.delegate.addItems(itemStacks);
        return this;
    }

    public DropQueue addXP(int amount) {
        if (this.delegate == null) {
            return this;
        }
        this.delegate.addXP(amount);
        return this;
    }

    public DropQueue setLocation(@NotNull Location location) {
        if (this.delegate == null) {
            return this;
        }
        this.delegate.setLocation(location);
        return this;
    }

    public DropQueue forceTelekinesis() {
        if (this.delegate == null) {
            return this;
        }
        this.delegate.forceTelekinesis();
        return this;
    }

    public void push() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.push();
    }
}

