/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai.entity;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.entities.Entities;
import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.core.entities.ai.EntityGoal;
import com.willfp.eco.core.serialization.KeyedDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;

public record EntityGoalAvoidEntity(@NotNull TestableEntity entity, double distance, double slowSpeed, double fastSpeed) implements EntityGoal<Mob>
{
    public static final KeyedDeserializer<EntityGoalAvoidEntity> DESERIALIZER = new Deserializer();

    private static final class Deserializer
    implements KeyedDeserializer<EntityGoalAvoidEntity> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public EntityGoalAvoidEntity deserialize(@NotNull Config config) {
            if (!(config.has("entity") && config.has("distance") && config.has("slowSpeed") && config.has("fastSpeed"))) {
                return null;
            }
            TestableEntity entity = Entities.lookup(config.getString("entity"));
            return new EntityGoalAvoidEntity(entity, config.getDouble("distance"), config.getDouble("slowSpeed"), config.getDouble("fastSpeed"));
        }

        @NotNull
        public NamespacedKey getKey() {
            return NamespacedKey.minecraft((String)"avoid_entity");
        }
    }
}

