/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai.entity;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.entities.ai.EntityGoal;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.recipe.parts.EmptyTestableItem;
import com.willfp.eco.core.serialization.KeyedDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;

public record EntityGoalTempt(double speed, @NotNull Collection<TestableItem> items, boolean canBeScared) implements EntityGoal<Mob>
{
    public static final KeyedDeserializer<EntityGoalTempt> DESERIALIZER = new Deserializer();

    public EntityGoalTempt(double speed, @NotNull TestableItem item, boolean canBeScared) {
        this(speed, List.of(item), canBeScared);
    }

    private static final class Deserializer
    implements KeyedDeserializer<EntityGoalTempt> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public EntityGoalTempt deserialize(@NotNull Config config) {
            if (!(config.has("speed") && config.has("items") && config.has("canBeScared"))) {
                return null;
            }
            Collection items = config.getStrings("items").stream().map(Items::lookup).filter(it -> !(it instanceof EmptyTestableItem)).collect(Collectors.toList());
            return new EntityGoalTempt(config.getDouble("speed"), items, config.getBool("canBeScared"));
        }

        @NotNull
        public NamespacedKey getKey() {
            return NamespacedKey.minecraft((String)"tempt");
        }
    }
}

