/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai.entity;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.entities.Entities;
import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.core.entities.ai.EntityGoal;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.serialization.KeyedDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.ItemStack;

public record EntityGoalUseItem(@NotNull ItemStack item, @NotNull Sound sound, @NotNull Predicate<LivingEntity> condition) implements EntityGoal<Mob>
{
    public static final KeyedDeserializer<EntityGoalUseItem> DESERIALIZER = new Deserializer();

    private static final class Deserializer
    implements KeyedDeserializer<EntityGoalUseItem> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public EntityGoalUseItem deserialize(@NotNull Config config) {
            if (!(config.has("item") && config.has("sound") && config.has("condition"))) {
                return null;
            }
            TestableEntity filter2 = Entities.lookup(config.getString("condition"));
            return new EntityGoalUseItem(Items.lookup(config.getString("item")).getItem(), Sound.valueOf((String)config.getString("sound").toUpperCase()), filter2::matches);
        }

        @NotNull
        public NamespacedKey getKey() {
            return NamespacedKey.minecraft((String)"use_item");
        }
    }
}

