/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai.target;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.entities.Entities;
import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.core.entities.ai.TargetGoal;
import com.willfp.eco.core.serialization.KeyedDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;

public record TargetGoalNonTameRandom(@NotNull TestableEntity target, boolean checkVisibility, @NotNull Predicate<LivingEntity> targetFilter) implements TargetGoal<Tameable>
{
    public static final KeyedDeserializer<TargetGoalNonTameRandom> DESERIALIZER = new Deserializer();

    public TargetGoalNonTameRandom(@NotNull TestableEntity target, boolean checkVisibility) {
        this(target, checkVisibility, it -> true);
    }

    private static final class Deserializer
    implements KeyedDeserializer<TargetGoalNonTameRandom> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public TargetGoalNonTameRandom deserialize(@NotNull Config config) {
            if (!config.has("targetClass") || !config.has("checkVisibility")) {
                return null;
            }
            if (config.has("targetFilter")) {
                TestableEntity filter2 = Entities.lookup(config.getString("targetFilter"));
                return new TargetGoalNonTameRandom(Entities.lookup(config.getString("target")), config.getBool("checkVisibility"), filter2::matches);
            }
            return new TargetGoalNonTameRandom(Entities.lookup(config.getString("target")), config.getBool("checkVisibility"));
        }

        @NotNull
        public NamespacedKey getKey() {
            return NamespacedKey.minecraft((String)"non_tame_random");
        }
    }
}

